/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jlb.cms.services.payment.salary;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jlb.cms.services.Common;
import kd.ebg.aqap.banks.jlb.cms.services.Packer;
import kd.ebg.aqap.banks.jlb.cms.services.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QrySalPaymentImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "200201";
        Element ap = Packer.createCommonHead(tr_code, Sequence.genSequence(), "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqId());
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"serial_no");
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        if (StringUtils.isEmpty((String)serial_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"QrySalPaymentImpl_7", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        }
        if (submitSuccessTime == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671ftr_acdt\u4e3a\u7a7a\u3002", (String)"QrySalPaymentImpl_8", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        if (!StringUtils.isEmpty((String)RequestContextUtils.getBankParameterValue((String)"signDate4Test"))) {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)RequestContextUtils.getBankParameterValue((String)"signDate4Test"));
        } else {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse rsp = Common.parseBankResponse(head);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u653e\u56de\u7684\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"QrySalPaymentImpl_1", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        String[] splits = new String[]{};
        if (!"0".equals(file_flag)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56defile_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u4ed8\u6b3e\u6570\u636e.", (String)"QrySalPaymentImpl_2", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        String serial_record = body.getChildTextTrim("serial_record");
        splits = StringUtils.split((String)serial_record, (String)"|");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim()).append("|");
            }
            logger.info("\u7b2c" + i + "\u6761\u4ed8\u6b3e\u6570\u636e\u7684\u5185\u5bb9\uff1a", (Object)buffer.toString());
            String STAT = splits[fieldNum * i + 9];
            String BATCH_NO = splits[fieldNum * i + 11];
            String CARD_NO = splits[fieldNum * i + 1];
            String ACNAME = splits[fieldNum * i + 3];
            String AMT = splits[fieldNum * i + 5];
            String ERR_MSG = splits[fieldNum * i + 10];
            PaymentInfo payInfo = Parser.findPaymentInfo(paymentInfos, BATCH_NO, CARD_NO, ACNAME, AMT);
            if (null == payInfo) continue;
            if ("6".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QrySalPaymentImpl_3", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("9".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalPaymentImpl_4", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalPaymentImpl_4", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
                continue;
            }
            if ("3".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QrySalPaymentImpl_5", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2 (200201\u4ea4\u6613)", (String)"QrySalPaymentImpl_6", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

