/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jlb.cms.services.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jlb.cms.services.Common;
import kd.ebg.aqap.banks.jlb.cms.services.Packer;
import kd.ebg.aqap.banks.jlb.cms.services.payment.salary.QrySalPaymentImpl;
import kd.ebg.aqap.banks.jlb.cms.services.proxy.UpLoadPayFile;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final String BATCHFILEHEDAER = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|";
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryPaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "300002";
        Element ap = Packer.createCommonHead(tr_code, Sequence.genSequence(), "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0");
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element totalAmtElement = JDomUtils.addChild((Element)body, (String)"amt");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        String fileName = paymentInfo.getBankBatchSeqId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        StringBuilder fileTextBuffer = new StringBuilder();
        fileTextBuffer.append(BATCHFILEHEDAER);
        fileTextBuffer.append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getCurrency()).append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append("|");
            fileTextBuffer.append("0").append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getAmount().setScale(2, 1).toString()).append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append("|");
            if (i >= paymentInfos.size() - 1) continue;
            fileTextBuffer.append("\r\n");
        }
        totalAmtElement.setText(totalAmt.setScale(2, 1).toString());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        UpLoadPayFile upLoadPayFile = new UpLoadPayFile();
        upLoadPayFile.setFileContent(fileTextBuffer.toString());
        upLoadPayFile.doBiz(fileName);
        return Common.createCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse rsp = Common.parseBankResponse(head);
        String serial_no = head.getChildTextTrim("serial_no");
        for (PaymentInfo info : paymentInfos) {
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"serial_no", (String)serial_no);
        }
        if ("0_0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymentImpl_2", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymentImpl_2", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryPaymentImpl_3", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryPaymentImpl_3", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44300002\u4ea4\u6613", (String)"SalaryPaymentImpl_4", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

