/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginUtils.getInstance().login();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSER18", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0220001", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData(list1, "Cash_Cst_AccNo", bankBalanceRequest.getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(list1, "CshMgt_Acc_TpCd", "1");
        JDomExtUtils.addChildCDData(list1, "CcyCd", bankBalanceRequest.getBankCurrency());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CDBBankResponse bankResp = CommonParser.getBankPreResponse(rspStr = CommonParser.preParse(rspStr));
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%1$s,%2$s", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("LIST1");
        Element list = (Element)list1.get(0);
        String currency = JDomExtUtils.getChildText((Element)list, (String)"CcyCd");
        String accAvlBal = JDomExtUtils.getChildText((Element)list, (String)"Acc_Avl_Bal");
        String ystdBl = JDomExtUtils.getChildText((Element)list, (String)"YstdBl");
        String infRpt_AcBa = JDomExtUtils.getChildText((Element)list, (String)"InfRpt_AcBa");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo info = new BalanceInfo();
        if (StringUtils.isEmpty((String)accAvlBal)) {
            this.setAvailableBalance(info, "0");
            this.setCurrentBalance(info, "0");
        } else {
            this.setAvailableBalance(info, accAvlBal);
            this.setCurrentBalance(info, infRpt_AcBa);
        }
        if (!StringUtils.isEmpty((String)ystdBl)) {
            this.setLastDayAvlBalance(info, ystdBl);
        }
        this.setBankAcnt(info, bankBalanceRequest.getAcnt());
        this.setBankCurrency(info, currency);
        info.setBalanceDateTime(LocalDateTime.now());
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(16);
        balanceInfoList.add(info);
        rsp.setBalances(balanceInfoList);
        return rsp;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSER18";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }
}

