/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.payment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.CZQueryPaymentImpl;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class CZPaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CZPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CZQueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.getInstance().login();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1G015011", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0120002", paymentInfo.getBankBatchSeqId());
        body.addContent((Content)request);
        String cstid = RequestContextUtils.getBankParameterValue((String)"cstid");
        JDomExtUtils.addChildCDData(request, "Cst_ID", cstid);
        JDomExtUtils.addChildCDData(request, "SdSMS_Ind", "0");
        JDomExtUtils.addChildCDData(request, "Cst_Nm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(request, "Pcs_Tp_ID", "00");
        JDomExtUtils.addChildCDData(request, "WF_FCN_ID", "G0010000");
        JDomExtUtils.addChildCDData(request, "BIZ_SUB_FCN_ID", "G0010002");
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "Pcs_StTm", date);
        JDomExtUtils.addChildCDData(request, "EBnk_SvAr_ID", RequestContextUtils.getBankParameterValue((String)"CoustomerNo"));
        JDomExtUtils.addChildCDData(request, "TDP_ID", RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomExtUtils.addChildCDData(request, "TDP_Nm", RequestContextUtils.getBankParameterValue((String)"cusname"));
        JDomExtUtils.addChildCDData(request, "Mgr_Ind", "0");
        JDomExtUtils.addChildCDData(request, "AccNo", paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(request, "CcyCd", paymentInfo.getCurrency());
        JDomExtUtils.addChildCDData(request, "Rqs_Amt", paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData(request, "P_TPL_NO", "00000000000000000000000000000000000000000000000000");
        Element BsnInf_Grp = JDomExtUtils.addChild((Element)request, (String)"BsnInf_Grp");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "CstPty_TxnSrlNo", paymentInfo.getBatchSeqId());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Hdl_InsID", BankBusinessConfig.getJBJGBHFromAcntNo(paymentInfo.getAccNo()));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "APPROVE_TYPE_CD", "02");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Aply_Chnl_TpCd", "0025");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Pyr_Cst_AccNo", paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Pyr_AccNm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Pyr_Adr", paymentInfo.getBankName());
        String xxhtbh = BankBusinessConfig.getXXHTBHFromAcntNo(paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Cptd_Bsn_Ctr_ID", xxhtbh);
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Rqs_Amt", paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "TnCcy_Cd", paymentInfo.getCurrency());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "PAY_TYPE_CD", StringUtils.isEmpty((String)xxhtbh) ? "2" : "1");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "PymDt", date);
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_BkCgyCd", paymentInfo.is2SameBank() ? "01" : "02");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_Cst_AccNo", paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_DpBkNm", paymentInfo.getIncomeBankName());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_Adr", paymentInfo.getIncomeBankAddress());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Use_Nm", paymentInfo.getUseCn());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "CstPty_Py_Jrnl_No", paymentInfo.getBankDetailSeqId());
        if (paymentInfo.is2SameBank()) {
            JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_DepBnk_No", paymentInfo.getIncomeCnaps());
        } else {
            JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPrt_BnkCD", paymentInfo.getIncomeCnaps());
        }
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RcvPtAc_Nm", paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "ASPD_ECD", "O0120002");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "SChl_No", "000000000000000");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "FwCtl_Node_ID", "000000000000000");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Cst_ID", RequestContextUtils.getBankParameterValue((String)"cstid"));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Cst_Nm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(BsnInf_Grp, "PdAr_ID", BankBusinessConfig.getCPHYHFromAccNo(paymentInfo.getAccNo()));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "SvM24Hr_Ind", "0");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Tmzon_ECD", "08");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "CCstTr_ID", RequestContextUtils.getBankParameterValue((String)"ccsttrid"));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "CCstTrNdID", RequestContextUtils.getBankParameterValue((String)"ccsttrnddid"));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RvPy_Txn_TpCd", "15");
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Cst_Dlv_Dt", date);
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"Cst_Dlv_Dt", (String)date);
        JDomExtUtils.addChildCDData(BsnInf_Grp, "Cst_Dlv_Tm", LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmssSSS")));
        JDomExtUtils.addChildCDData(BsnInf_Grp, "RvPy_ExMd_Cd", "0");
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        return new PaymentImpl().parse(bankPayRequest, rspStr);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1G015011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d22\u8d44\u6237\u652f\u4ed8\u8f6c\u8d26\u3002", (String)"CZPaymentImpl_0", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String accNo = paymentInfo.getAccNo();
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isJGAcc(accNo) != false;
    }
}

