/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzcb.dc.services.payment;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzcb.dc.GZCBEBankDataHelper;
import kd.ebg.aqap.banks.gzcb.dc.helper.DomHelper;
import kd.ebg.aqap.banks.gzcb.dc.limit.PayLoginAccess;
import kd.ebg.aqap.banks.gzcb.dc.limit.PayLoginAccessManager;
import kd.ebg.aqap.banks.gzcb.dc.loginout.LoginAndOut;
import kd.ebg.aqap.banks.gzcb.dc.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private int contentLength = 0;

    public int getBatchSize() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        }
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        try {
            la.getToken();
            String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
            Element GZCBEBankData = new Element("GZCBEBankData");
            Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
            String serialNo = Sequence.genSequence();
            JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
            String date = DateUtil.formatDateTime((Date)new Date());
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
            Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
            JDomUtils.addChild((Element)ReqParam, (String)"JYXH", (String)paymentInfos[0].getBankDetailSeqId());
            String sign = serialNo + "|" + date + "|" + paymentInfos[0].getBankDetailSeqId() + "|";
            Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
            JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)new SignService().sign(sign));
            Document document = new Document(GZCBEBankData);
            String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
            String saq = GZCBEBankDataHelper.add(xml, sessionId, "srv009_transferResultInfoQuery");
            try {
                this.contentLength = saq.getBytes(RequestContextUtils.getCharset()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            String string = saq;
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (EBServiceException e) {
                e.printStackTrace();
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String xml = GZCBEBankDataHelper.cut(rspStr, true);
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element GZCBEBankData = JDomUtils.string2Root((String)xml, (String)RequestContextUtils.getCharset());
        Element opRep = DomHelper.getChildElementNotNull(GZCBEBankData, "opRep");
        String retCode = DomHelper.getChildTextNotNull(opRep, "retCode");
        String errMsg = DomHelper.getChildText(opRep, "errMsg");
        if (!retCode.equals("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38,\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"QueryPayImpl_9", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), retCode, errMsg));
        }
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String JYZT = DomHelper.getChildTextNotNull(opResult, "JYZT", ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        if ("90".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        } else if ("91".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        } else if ("60".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_7", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv009_transferResultInfoQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2 srv009_transferResultInfoQuery\u3002", (String)"QueryPayImpl_8", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = RequestContextUtils.getCharset();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Length", Integer.toString(this.contentLength));
        factory.setHttpHeader("Content-Type", "text/xml; charset=" + encoding);
    }
}

