/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc.services.handler;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field34F;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CITI_DC_MT942_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CITI_DC_MT942_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        if (fileName.contains("-") || fileName.contains("(") && fileName.contains(")")) {
            return false;
        }
        return fileName.contains("MT942");
    }

    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List list = super.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.parseCurrDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"CITI_DC_MT942_Handler_1", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), name, e));
            return;
        }
    }

    private void parseCurrDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        this.logger.info("Field25:" + field25.toString());
        Field34F field34F = new Field34F(swiftTextBlock.getTagValue("34F"));
        String acntNumber = field25.getComponent1();
        String currency = field34F.getComponent1();
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailList, List<PaymentInfo> payInfoList) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            String onlyId = field61.toString().replaceAll(", ", "");
            onlyId = onlyId.substring(1, onlyId.length() - 1);
            Date now = new Date();
            OverseaDetail detail = new OverseaDetail();
            detail.setDetail_no(onlyId);
            detail.setCustomId(EBContext.getContext().getCustomID());
            String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String time = today.substring(0, 4) + field61.getComponent2();
            if (!today.equals(time)) {
                this.logger.info(ResManager.loadKDString((String)"\u8be5\u7b14\u660e\u7ec6\u4ea4\u6613\u65e5\u671f\u4e0d\u662f\u4eca\u5929\uff0c\u4e0d\u8fdb\u884c\u89e3\u6790\u3002", (String)"CITI_DC_MT942_Handler_2", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]));
                continue;
            }
            detail.setTxDate(LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setNumber(acntNumber);
            detail.setPayBankName("CITI");
            detail.setPayBankVersion(this.context.getBankVersionID());
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCurrency(currency);
            detail.setTransType(field61.getComponent6());
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit) || "EC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit) || "ED".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else if ("RC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else if ("RD".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411\u3002", (String)"CITI_DC_MT942_Handler_3", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            this.logger.info("Field61:" + field61.toString());
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                Field86 field86 = new Field86(tag86.getTagValue());
                this.logger.info("Field86:" + field86.toString());
                StringBuilder str = new StringBuilder();
                List field86List = field86.getComponents();
                for (String fie : field86List) {
                    if (StringUtils.isEmpty((String)fie) || "null".equals(fie)) continue;
                    str.append(fie);
                }
                detail.setExplanation(str.toString());
                if ("DEBIT".equals(detail.getCordFlag())) {
                    this.parseField86Payment(str.toString(), detail);
                } else {
                    this.parseField86Collect(str.toString(), detail);
                }
                if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
                    detail.setBenefitAccName("");
                }
            }
            try {
                PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId((String)custRef);
                if (paymentInfo != null) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CITI_DC_MT942_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CITI_DC_MT942_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
            }
            catch (Exception e) {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s\u3002", (String)"CITI_DC_MT942_Handler_4", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), e));
            }
            detailList.add(detail);
        }
    }

    private void parseField86Payment(String field86, OverseaDetail detail) {
        String str;
        int begin = field86.indexOf("/BI/");
        if (begin != -1) {
            str = field86.substring(begin + 4);
            String accNo = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccNo(accNo);
        }
        if ((begin = field86.indexOf("/BN/")) != -1) {
            str = field86.substring(begin + 4);
            String accName = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccName(accName);
        }
        if ((begin = field86.indexOf("/AB/")) != -1) {
            str = field86.substring(begin + 4);
            String bankName = str.substring(0, str.indexOf("/"));
            detail.setBenefitBankName(bankName);
        }
    }

    private void parseField86Collect(String field86, OverseaDetail detail) {
        int begin = field86.indexOf("/BO1/");
        int begin2 = field86.indexOf("/OB1/");
        if (begin != -1) {
            String str = field86.substring(begin + 4);
            String accName = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccName(accName);
            begin = field86.indexOf("/BO/");
            if (begin != -1) {
                str = field86.substring(field86.indexOf("/BO/") + 4);
                String accNo = str.substring(0, str.indexOf("/"));
                accNo = Pattern.compile("[^(0-9)]").matcher(accNo).replaceAll("").trim();
                detail.setBenefitAccNo(accNo);
            }
            if ((begin = field86.indexOf("/OB/")) != -1) {
                str = field86.substring(begin + 4);
                String bankName = str.substring(0, str.indexOf("/"));
                detail.setBenefitBankName(bankName);
            }
        } else if (begin2 != -1) {
            String str = field86.substring(begin + 4);
            String bankName = str.substring(0, str.indexOf("/"));
            detail.setBenefitBankName(bankName);
            begin2 = field86.indexOf("/OB/");
            if (begin2 != -1) {
                str = field86.substring(field86.indexOf("/OB/") + 4);
                String accNo = str.substring(0, str.indexOf("/"));
                accNo = Pattern.compile("[^(0-9)]").matcher(accNo).replaceAll("").trim();
                detail.setBenefitAccNo(accNo);
            }
            if ((begin2 = field86.indexOf("/BO/")) != -1) {
                str = field86.substring(field86.indexOf("/BO/") + 4);
                String accName = str.substring(0, str.indexOf("/"));
                detail.setBenefitAccName(accName);
            }
        } else {
            this.logger.info(ResManager.loadKDString((String)"\u4e0d\u4fee\u6539", (String)"CITI_DC_MT942_Handler_5", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]));
        }
    }
}

