/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);
    private static final String tradeName = "BY0007";

    public String pack(BankBalanceRequest request) {
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot(tradeName);
        Element loopData = new Element("loopData");
        Element row = new Element("row");
        JDomUtils.addChild((Element)row, (String)"bankAcc", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)loopData, (Element)row);
        JDomUtils.addChild((Element)root, (Element)head);
        JDomUtils.addChild((Element)root, (Element)loopData);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber(tradeName) + RspMsg;
        return TCommon.createCommonMsg(rspmsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        Element map = JDomUtils.getChildElement((Element)root, (String)"map");
        String recordTotal = JDomUtils.getChildText((Element)map, (String)"recordTotal");
        if (!"0".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)retMsg));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        Element loopData = JDomUtils.getChildElement((Element)root, (String)"loopData");
        Element row = JDomUtils.getChildElement((Element)loopData, (String)"row");
        String accNo = row.getChildTextTrim("bankAcc");
        String bankBal = row.getChildText("bankBal");
        String availBal = row.getChildText("availBal");
        this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), accNo);
        this.setCurrentBalance(balanceInfo, bankBal);
        this.setAvailableBalance(balanceInfo, availBal);
        balanceInfo.setBankCurrency(rqst.getHeader().getBankCurrency());
        LocalDateTime localDateTime = LocalDateTime.now();
        balanceInfo.setBalanceDateTime(localDateTime);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>();
        balanceInfoList.add(balanceInfo);
        bankBalanceResponse.setBalances(balanceInfoList);
        return bankBalanceResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return tradeName;
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

