/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.dlb.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element ap = DLB_DC_Packer.builedHead("416B300001", paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno");
        JDomUtils.addChild((Element)body, (String)"as_acname");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr");
        JDomUtils.addChild((Element)body, (String)"cert_type");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr");
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)body, (String)"purpose", (String)(paymentInfo.getBankDetailSeqId() + "@KD" + paymentInfo.getExplanation()));
        } else {
            JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        }
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date");
        JDomUtils.addChild((Element)body, (String)"booking_time");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfo.getMobiles());
        JDomUtils.addChild((Element)body, (String)"delay_flag", (String)"0");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        String xmlInfo = DLBUtils.forStringLengthByte(xmlStr);
        return xmlInfo;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        rspStr = rspStr.substring(12);
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info);
        if ("0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u4ed8\u6b3e", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

