/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MessageUtil {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(MessageUtil.class);

    public static Document string2Doc(String xmlStr, String encoding) throws EBServiceException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xmlStr = xmlStr.trim();
        Document doc = null;
        try {
            InputStreamReader byteArrayIS = new InputStreamReader((InputStream)new ByteArrayInputStream(xmlStr.getBytes()), encoding);
            doc = builder.build((Reader)byteArrayIS);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        catch (JDOMException e) {
            log.error(e.toString());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        catch (IOException e) {
            log.error(e.toString());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        return doc;
    }

    public static String formatNumber(long num) {
        NumberFormat numFormat = NumberFormat.getInstance();
        numFormat.setMinimumIntegerDigits(10);
        return numFormat.format(num).replaceAll(",", "");
    }
}

