/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sxnxs.dc.services.detail;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.AmountUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.MessageUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.ParserRsp;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final int PAGE_SIZE = 50;

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element Request = MessageUtil.getHead("S51510", "YQBC04", Sequence.gen14Sequence());
        Element Body = new Element("Body");
        JDomUtils.addChild((Element)Body, (String)"AcctNo", (String)bankDetailRequest.getAcnt().getAccNo());
        String beginDate = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)Body, (String)"StartDate", (String)beginDate);
        JDomUtils.addChild((Element)Body, (String)"EndDate", (String)endDate);
        String currentPage = this.getCurrentPage();
        if (currentPage.equalsIgnoreCase("0")) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        JDomUtils.addChild((Element)Body, (String)"TurnPgIttLo", (String)currentPage);
        JDomUtils.addChild((Element)Body, (String)"PgDsplRcrdNum", (String)"50");
        JDomUtils.addChild((Element)Request, (Element)Body);
        String encoding = RequestContextUtils.getCharset();
        String xml = JDomUtils.root2String((Element)Request, (String)encoding);
        return MessageUtil.getSendMsg(xml);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        int nextPage = Integer.parseInt(this.getCurrentPage()) + 50;
        this.setCurrentPage(nextPage);
        String NO_DATA_CODE = "DPS9000";
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        BankResponse res = ParserRsp.parseRsp(s);
        if (!"S".equals(res.getResponseCode())) {
            if (res.getResponseMessage().startsWith("DPS9000")) {
                return new EBBankDetailResponse(detailInfos);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{res.getResponseCode(), res.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("Body");
        BankAcnt reqBankAcnt = bankDetailRequest.getAcnt();
        Element recordList = body.getChild("RecordList");
        String rcrdTotNum = body.getChildText("RcrdTotNum");
        int total = Integer.parseInt(rcrdTotNum);
        if (total >= nextPage) {
            this.setLastPage(false);
        }
        List records = recordList.getChildren("Record");
        for (Element element : records) {
            DetailInfo detailInfo = new DetailInfo();
            String AcctNo = element.getChildText("AcctNo");
            String CCY = element.getChildText("CCY");
            detailInfo.setCurrency(CCY);
            String TransName = element.getChildText("TransName");
            String OaAcctNo = element.getChildText("OaAcctNo");
            String OaAcctName = element.getChildText("OaAcctName");
            String TransDate = element.getChildText("TransDate");
            String DrAmount = element.getChildText("DrAmount");
            String CrAmount = element.getChildText("CrAmount");
            String AcctBalance = element.getChildText("AcctBalance");
            String BankSeqNO = element.getChildText("BankSeqNO");
            String Crflag = element.getChildText("Crflag");
            String REM = element.getChildText("REM");
            detailInfo.setAccName(reqBankAcnt.getAccName());
            detailInfo.setAccNo(reqBankAcnt.getAccNo());
            detailInfo.setBankName(reqBankAcnt.getBankName());
            detailInfo.setOppAccName(OaAcctName);
            detailInfo.setOppAccNo(OaAcctNo);
            detailInfo.setExplanation(REM);
            detailInfo.setBalance(AmountUtil.getAmountToEas(AcctBalance));
            detailInfo.setTransDate(LocalDate.parse(TransDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            detailInfo.setTransTime(LocalDateTime.parse(TransDate + "000000", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
            detailInfo.setCreditAmount(AmountUtil.getAmountToEas(CrAmount));
            detailInfo.setDebitAmount(AmountUtil.getAmountToEas(DrAmount));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(BankSeqNO);
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "S51510";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]);
    }
}

