/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class QueryPayParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element XFERINQTRNRS = SECURITIES_MSGSRSV1.getChild("XFERINQTRNRS");
        String packageId = XFERINQTRNRS.getChildText("TRNUID");
        Element pub = XFERINQTRNRS.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        this.log.info("return code:" + recode);
        if ("0".equalsIgnoreCase(recode)) {
            String reMessage = pub.getChildTextTrim("MESSAGE");
            String errorMessage = pub.getChildText("MESSAGE");
            String bankMsg = StringUtils.isEmpty((String)reMessage) ? errorMessage : reMessage;
            Element XFERINQRS = XFERINQTRNRS.getChild("XFERINQRS");
            Element li = XFERINQRS.getChild("XFERLIST");
            String to = li.getChildText("TO");
            if ("-1".equalsIgnoreCase(to)) {
                String msg = ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u8fd4\u56de\u8282\u70b9<TO>-1<TO>\uff0c\u8868\u793a\u65e0\u6b64\u8bb0\u5f55\uff0c\u8bf7\u548c\u94f6\u884c\u4eba\u5458\u6838\u5b9e\u8be5\u4ea4\u6613\u6700\u7ec8\u72b6\u6001\u3002", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)msg, (String)recode, (String)bankMsg);
                return;
            }
            Element e = li.getChild("XFER");
            Element er = e.getChild("XFERPRCSTS");
            String xferprCode = er.getChildText("XFERPRCCODE");
            String message = er.getChildText("MESSAGE");
            if (!StringUtils.isEmpty((String)xferprCode) || !StringUtils.isEmpty((String)message)) {
                bankMsg = xferprCode + ", " + message;
            }
            if ("CANCEL".equalsIgnoreCase(xferprCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)recode, (String)bankMsg);
            } else if ("PAYOUT".equalsIgnoreCase(xferprCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)"", (String)recode, (String)bankMsg);
            } else if ("FAIL".equalsIgnoreCase(xferprCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)recode, (String)bankMsg);
            } else if ("AUDITING".equalsIgnoreCase(xferprCode) || "AUDITED".equalsIgnoreCase(xferprCode) || "WAIT_FOR_AUDIT".equalsIgnoreCase(xferprCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)"", (String)recode, (String)bankMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)recode, (String)bankMsg);
            }
        } else {
            String errorMsg = pub.getChildTextTrim("MESSAGE");
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)recode, (String)errorMsg);
        }
    }
}

