/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.agency;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.payment.agency.AgentQueryPayImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.agency.PayPacker;
import kd.ebg.aqap.banks.cib.dc.services.payment.agency.PayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;

public class AgentPaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "ASYNBATCHMRCHAGENTTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3\uff08\u6587\u6863v3.9.1 ASYNBATCHMRCHAGENTTRNRQ\uff09", (String)"AgentPaymentImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AgentQueryPayImpl.class;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return (this.isSalary(paymentInfo) || Objects.equals("pay", paymentInfo.getSubBizType()) && (Objects.equals(paymentInfo.getUseCN(), ResManager.loadKDString((String)"\u5de5\u8d44", (String)"AgentPaymentImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0])) || Objects.equals(paymentInfo.getUseCN(), ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"AgentPaymentImpl_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0])))) && paymentInfo.getExplanation().indexOf(ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6", (String)"AgentPaymentImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0])) != -1;
    }

    public String pack(BankPayRequest request) {
        return new PayPacker().packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new PayParser().parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

