/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.income;

import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element stmt = JDomUtils.addChild((Element)msgsv, (String)"GATHERTRNRQ");
            JDomUtils.addChild((Element)stmt, (String)"TRNUID", (String)paymentInfos[i].getBankDetailSeqId());
            Element rd = JDomUtils.addChild((Element)stmt, (String)"GATHERRQ");
            Element info = JDomUtils.addChild((Element)rd, (String)"GATHERINFO");
            Element ACCTTO = JDomUtils.addChild((Element)info, (String)"ACCTTO");
            JDomUtils.addChild((Element)ACCTTO, (String)"ACCTID", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)info, (String)"FIRMCODE", (String)BankBusinessConfig.getFirmCodeByAcnt(paymentInfos[0].getAccNo()));
            JDomUtils.addChild((Element)info, (String)"BIZCODE", (String)this.getBIZCODE(paymentInfos[i]));
            JDomUtils.addChild((Element)info, (String)"LIMITDAYS", (String)"3");
            JDomUtils.addChild((Element)info, (String)"TITLE", (String)"");
            String exp = paymentInfos[0].getExplanation();
            String kd = "";
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
                kd = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
            }
            JDomUtils.addChild((Element)info, (String)"MEMO", (String)exp);
            JDomUtils.addChild((Element)info, (String)"TRNTYPE", (String)"1");
            Element PAYINFO = JDomUtils.addChild((Element)info, (String)"PAYINFO");
            JDomUtils.addChild((Element)PAYINFO, (String)"INDX", (String)String.valueOf(i));
            JDomUtils.addChild((Element)PAYINFO, (String)"CONTRACTID", (String)BankBusinessConfig.getContractIdByAcnt(paymentInfos[0].getIncomeAccNo()));
            Element ACCTFROM = JDomUtils.addChild((Element)PAYINFO, (String)"ACCTFROM");
            String incomeAcco = paymentInfos[i].getIncomeAccNo();
            JDomUtils.addChild((Element)ACCTFROM, (String)"ACCTID", (String)incomeAcco);
            JDomUtils.addChild((Element)ACCTFROM, (String)"NAME", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)ACCTFROM, (String)"BANKDESC", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)ACCTFROM, (String)"BANKNUM", (String)paymentInfos[i].getIncomeCnaps());
            JDomUtils.addChild((Element)PAYINFO, (String)"PAYMODE", (String)(paymentInfos[i].is2SameBank() ? "0" : "1"));
            JDomUtils.addChild((Element)PAYINFO, (String)"APPLYAMT", (String)paymentInfos[i].getAmount().setScale(2, 1).toString());
            if (StringUtils.isEmpty((String)kd)) {
                JDomUtils.addChild((Element)info, (String)"PURPOSE", (String)exp);
            } else {
                JDomUtils.addChild((Element)info, (String)"PURPOSE", (String)kd);
            }
            JDomUtils.addChild((Element)PAYINFO, (String)"BIZCODE1", (String)"");
            JDomUtils.addChild((Element)PAYINFO, (String)"BIZCODE2", (String)"");
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    private String getBIZCODE(PaymentInfo paymentInfo) {
        String useCode = "09900";
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "GATHERRQ";
        String bankVersion = "CIB_DC";
        String useCn = paymentInfo.getExplanation();
        useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
        return useCode;
    }
}

