/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.linkpay;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LinkPayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u8054\u52a8\u652f\u4ed8", (String)"LinkPayPacker_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        if (paymentInfos[0].is2Individual()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u4e0d\u652f\u6301\u8054\u52a8\u5bf9\u79c1\u652f\u4ed8\u3002", (String)"LinkPayPacker_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element xpm = JDomUtils.addChild((Element)msgsv, (String)"XPMTTRNRQ");
        JDomUtils.addChild((Element)xpm, (String)"TRNUID", (String)paymentInfos[0].getBankDetailSeqId());
        Element xmptrq = JDomUtils.addChild((Element)xpm, (String)"XMPTRQ");
        Element fundAcct = JDomUtils.addChild((Element)xmptrq, (String)"FUNDACCT");
        JDomUtils.addChild((Element)fundAcct, (String)"ACCTID", (String)paymentInfos[0].getThirdAccNo());
        Element xferInfo = JDomUtils.addChild((Element)xmptrq, (String)"XFERINFO");
        Element acctFrom = JDomUtils.addChild((Element)xferInfo, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acctFrom, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)acctFrom, (String)"NAME", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)acctFrom, (String)"BANKDESC", (String)paymentInfos[0].getBankName());
        JDomUtils.addChild((Element)acctFrom, (String)"CITY", (String)paymentInfos[0].getAccCity());
        Element acctTo = JDomUtils.addChild((Element)xferInfo, (String)"ACCTTO");
        if (paymentInfos[0].is2SameBank()) {
            acctTo.setAttribute("INTERBANK", "Y");
        } else {
            acctTo.setAttribute("INTERBANK", "N");
        }
        if (paymentInfos[0].is2SameCity()) {
            acctTo.setAttribute("LOCAL", "Y");
        } else {
            acctTo.setAttribute("LOCAL", "N");
        }
        JDomUtils.addChild((Element)acctTo, (String)"ACCTID", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)acctTo, (String)"NAME", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)acctTo, (String)"BANKDESC", (String)paymentInfos[0].getIncomeBankName());
        String bankNumber = paymentInfos[0].getIncomeCnaps();
        if (StringUtils.isEmpty((String)bankNumber)) {
            bankNumber = "";
        }
        JDomUtils.addChild((Element)acctTo, (String)"BANKNUM", (String)bankNumber.trim());
        JDomUtils.addChild((Element)acctTo, (String)"CITY", (String)paymentInfos[0].getIncomeCity());
        JDomUtils.addChild((Element)xferInfo, (String)"CHEQUENUM", (String)"");
        JDomUtils.addChild((Element)xferInfo, (String)"CURSYM", (String)"RMB");
        JDomUtils.addChild((Element)xferInfo, (String)"TRNAMT", (String)paymentInfos[0].getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)xferInfo, (String)"PMTMODE", (String)"REAL_TIME");
        String exp = paymentInfos[0].getExplanation();
        String kd = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            kd = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        if (StringUtils.isEmpty((String)kd)) {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)exp);
        } else {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)kd);
        }
        JDomUtils.addChild((Element)xferInfo, (String)"MEMO", (String)exp);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }
}

