/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.oversea.QueryOrgIdHelper;
import kd.ebg.aqap.banks.cib.dc.services.payment.oversea.QueryOverseaPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.AttachmentUploadUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OverseaPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryOverseaPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element outwardremitapplytrnrq = JDomUtils.addChild((Element)msgsv, (String)"OUTWARDREMITAPPLYTRNRQ");
        JDomUtils.addChild((Element)outwardremitapplytrnrq, (String)"TRNUID", (String)paymentInfo.getBankDetailSeqId());
        Element rqbody = JDomUtils.addChild((Element)outwardremitapplytrnrq, (String)"RQBODY");
        JDomUtils.addChild((Element)rqbody, (String)"REMIT_TYPE", (String)"1");
        JDomUtils.addChild((Element)rqbody, (String)"REMIT_CURRENCY", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)rqbody, (String)"REMIT_AMT", (String)paymentInfo.getAmount().toPlainString());
        if (paymentInfo.isDiffCurrency()) {
            JDomUtils.addChild((Element)rqbody, (String)"PURCHASE_ACCT", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)rqbody, (String)"PURCHASE_AMT", (String)paymentInfo.getAmount().toPlainString());
        } else {
            JDomUtils.addChild((Element)rqbody, (String)"SPOT_ACCT", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)rqbody, (String)"SPOT_AMT", (String)paymentInfo.getAmount().toPlainString());
        }
        JDomUtils.addChild((Element)rqbody, (String)"PAYER_NAME", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)rqbody, (String)"PAYER_ADDR", (String)paymentInfo.getPayerAddress());
        JDomUtils.addChild((Element)rqbody, (String)"SOCIAL_CODE", (String)paymentInfo.getSocialCode());
        Element payee_info = JDomUtils.addChild((Element)rqbody, (String)"PAYEE_INFO");
        JDomUtils.addChild((Element)payee_info, (String)"ACCT", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)payee_info, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)payee_info, (String)"ADDR", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)payee_info, (String)"BANK_NAME", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)payee_info, (String)"BANK_SWIFT", (String)paymentInfo.getIncomeSwiftCode());
        JDomUtils.addChild((Element)payee_info, (String)"BANK_ADDR", (String)paymentInfo.getIncomeBankAddress());
        JDomUtils.addChild((Element)payee_info, (String)"AGENT_BANK_NAME", (String)"");
        JDomUtils.addChild((Element)payee_info, (String)"AGENT_BANK_SWIFT", (String)"");
        JDomUtils.addChild((Element)payee_info, (String)"AGENT_BANK_ADDR", (String)"");
        JDomUtils.addChild((Element)payee_info, (String)"AGENT_BANK_ACCT", (String)"");
        JDomUtils.addChild((Element)payee_info, (String)"COUNTRY_NAME", (String)"");
        CountryISOCode incomeCountry = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (incomeCountry == null) {
            incomeCountry = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        JDomUtils.addChild((Element)payee_info, (String)"COUNTRY_CODE", (String)incomeCountry.geteChart3());
        JDomUtils.addChild((Element)rqbody, (String)"REMIT_POSTSCRIPT", (String)paymentInfo.getExplanation());
        String pay_mode = "O";
        if ("1".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_mode = "P";
        } else if ("0".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_mode = "A";
        } else if ("2".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_mode = "R";
        }
        JDomUtils.addChild((Element)rqbody, (String)"PAY_MODE", (String)pay_mode);
        String feeMode = "OUR";
        if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "BEN";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "SHA";
        }
        JDomUtils.addChild((Element)rqbody, (String)"FEE_MODE", (String)feeMode);
        JDomUtils.addChild((Element)rqbody, (String)"BOND_GOODS_FLAG", (String)(paymentInfo.isBondGoodsFlag() ? "Y" : "N"));
        JDomUtils.addChild((Element)rqbody, (String)"CONTRACT_NO", (String)paymentInfo.getContractNo());
        JDomUtils.addChild((Element)rqbody, (String)"INVOICE_NO", (String)paymentInfo.getInvoiceNo());
        JDomUtils.addChild((Element)rqbody, (String)"AUTH_FILE_NO", (String)"");
        JDomUtils.addChild((Element)rqbody, (String)"APPLICANT_NAME", (String)paymentInfo.getApplyName());
        JDomUtils.addChild((Element)rqbody, (String)"APPLICANT_PHONE", (String)paymentInfo.getApplyPhone());
        QueryOrgIdHelper queryOrgIdHelper = new QueryOrgIdHelper();
        JDomUtils.addChild((Element)rqbody, (String)"LAND_ORG", (String)queryOrgIdHelper.getOrgId());
        JDomUtils.addChild((Element)rqbody, (String)"PRIORITY", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)rqbody, (String)"BUSINESS_TYPE_CODE", (String)paymentInfo.getBusinessTypeCode());
        String payAttribute = "6";
        if ("D".equalsIgnoreCase(paymentInfo.getPayAttribute())) {
            payAttribute = "3";
        } else if ("E".equalsIgnoreCase(paymentInfo.getPayAttribute())) {
            payAttribute = "2";
        } else if ("M".equalsIgnoreCase(paymentInfo.getPayAttribute())) {
            payAttribute = "5";
        } else if ("S".equalsIgnoreCase(paymentInfo.getPayAttribute())) {
            payAttribute = "4";
        } else if ("X".equalsIgnoreCase(paymentInfo.getPayAttribute())) {
            payAttribute = "1";
        }
        JDomUtils.addChild((Element)rqbody, (String)"PAYMENT_PROPERTY", (String)payAttribute);
        JDomUtils.addChild((Element)rqbody, (String)"IN_OUT_FLAG", (String)(incomeCountry.geteChart3().equalsIgnoreCase("CHN") ? "1" : "2"));
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element xferprcsts;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element outwardremitapplytrnrs = eb1.getChild("OUTWARDREMITAPPLYTRNRS");
        Element status = outwardremitapplytrnrs.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        Element rsbody = outwardremitapplytrnrs.getChild("RSBODY");
        String xferprCode = null;
        if (rsbody != null && (xferprcsts = rsbody.getChild("XFERPRCSTS")) != null) {
            xferprCode = JDomUtils.getChildText((Element)xferprcsts, (String)"XFERPRCCODE");
            message = JDomUtils.getChildText((Element)xferprcsts, (String)"MESSAGE");
        }
        String responseCode = code;
        String responseMsg = message;
        if (!StringUtils.isEmpty((String)code) && "0".equalsIgnoreCase(code) && StringUtils.isNotEmpty((String)xferprCode)) {
            responseCode = xferprCode;
        } else if (!StringUtils.isEmpty((String)code) && "10514".equalsIgnoreCase(code)) {
            responseCode = "AUDITING";
        }
        if ("PAYOUT".equalsIgnoreCase(responseCode) || "AUDITING".equalsIgnoreCase(responseCode) || "AUDITED".equalsIgnoreCase(responseCode) || "WAIT_FOR_AUDIT".equalsIgnoreCase(responseCode) || "PROCESSING".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)responseCode, (String)responseMsg);
            EBContext context = EBContext.getContext();
            AttachmentUploadUtil.async((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID(), (String)context.getLogger_batch_no());
        } else if ("FAIL".equalsIgnoreCase(responseCode) || "CANCEL".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentFailState((List)paymentInfos, (String)"", (String)responseCode, (String)responseMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)responseCode, (String)responseMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "OUTWARDREMITAPPLYTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u884c\u8de8\u5883\u6c47\u51fa\u6c47\u6b3e\u7533\u8bf7", (String)"OverseaPayImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

