/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salary;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.salary.SalaryCodeUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = this.parserSalaryResponse(paymentInfos, root);
        if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        Element secMsg = JDomUtils.getChildElement((Element)root, (String)"SECURITIES_MSGSRSV1");
        Element rpayoffInQ = JDomUtils.getChildElementNotNull((Element)secMsg, (String)"RPAYOFFINQTRNRS");
        Element rpayoffrs = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"RPAYOFFRS");
        Element rpayoffinfo = JDomUtils.getChildElement((Element)rpayoffrs, (String)"RPAYOFFINFO");
        Element acctfrom = JDomUtils.getChildElement((Element)rpayoffinfo, (String)"ACCTFROM");
        String accNo = JDomUtils.getChildText((Element)acctfrom, (String)"ACCTID");
        Element rpayoffList = JDomUtils.getChildElement((Element)rpayoffinfo, (String)"RPAYOFFLIST");
        Element offerFacts = JDomUtils.getChildElement((Element)rpayoffrs, (String)"XFERPRCSTS");
        String factsCode = null;
        if (null != offerFacts) {
            factsCode = JDomUtils.getChildText((Element)offerFacts, (String)"XFERPRCCODE");
        }
        if (null != factsCode && factsCode.equalsIgnoreCase("FAIL")) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankResponse.getResponseCode(), (String)JDomUtils.getChildText((Element)offerFacts, (String)"MESSAGE"));
            return;
        }
        List rpayoffs = rpayoffList.getChildren("RPAYOFF");
        if (null == rpayoffs || rpayoffs.size() == 0) {
            Element XFERPRCSTS = rpayoffrs.getChild("XFERPRCSTS");
            if (null != XFERPRCSTS) {
                String XFERPRCCODE = XFERPRCSTS.getChildText("XFERPRCCODE");
                String MESSAGE = XFERPRCSTS.getChildText("MESSAGE");
                if ("WAIT_FOR_AUDIT".equals(XFERPRCCODE)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCCODE, (String)MESSAGE);
                } else if ("FAIL".equals(XFERPRCCODE)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCCODE, (String)MESSAGE);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCCODE, (String)MESSAGE);
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            }
        } else {
            HashMap bankReturnStatusMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Element rpInfo : rpayoffs) {
                String detialSequence = JDomUtils.getChildText((Element)rpInfo, (String)"INDX");
                String status = JDomUtils.getChildText((Element)rpInfo, (String)"STATUS");
                String errorMsg = JDomUtils.getChildText((Element)rpInfo, (String)"ERRMSG");
                BankResponse bankResp = new BankResponse();
                bankResp.setResponseCode(status);
                bankResp.setResponseMessage(errorMsg);
                bankReturnStatusMap.put(detialSequence, bankResp);
            }
            SalaryCodeUtils.setPaymentInfoStatus(bankReturnStatusMap, paymentInfos);
        }
    }

    private BankResponse parserSalaryResponse(PaymentInfo[] paymentInfos, Element root) throws EBServiceException {
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element rpayoffInQ = JDomUtils.getChildElement((Element)secmsg, (String)"RPAYOFFINQTRNRS");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        return bankResponse;
    }
}

