/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salarynew;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.salary.SalaryCodeUtils;
import kd.ebg.aqap.banks.cib.dc.services.payment.salarynew.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayOffImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element rpayoffQtr = JDomUtils.addChild((Element)msgsv, (String)"QUERYASYNPAYOFFTRANTRNRQ");
        JDomUtils.addChild((Element)rpayoffQtr, (String)"TRNUID", (String)Sequence.gen18Sequence());
        Element xferInQrq = JDomUtils.addChildAttribute((Element)rpayoffQtr, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)xferInQrq, (String)"CLIENTREF", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        this.logger.info("\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2");
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element rpayoffInQ = JDomUtils.getChildElement((Element)secmsg, (String)"QUERYASYNPAYOFFTRANTRNRS");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        Element rsbody = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"RSBODY");
        String resultcode = JDomUtils.getChildText((Element)rsbody, (String)"RESULTCODE");
        String errmessage = JDomUtils.getChildText((Element)rsbody, (String)"ERRMESSAGE");
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayOffImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        List content = rsbody.getChildren("CONTENT");
        for (Element element : content) {
            String indx = JDomUtils.getChildText((Element)element, (String)"INDX");
            this.logger.info("\u83b7\u53d6\u7684\u5e8f\u53f7\uff1a" + indx);
            String statusPay = JDomUtils.getChildText((Element)element, (String)"STATUS");
            String errmsg = JDomUtils.getChildText((Element)element, (String)"ERRMSG");
            PaymentInfo payInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)indx);
            if (payInfo == null) continue;
            SalaryCodeUtils.setPaymentInfoStatus(payInfo, statusPay, errmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

