/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzc.dc.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Packer;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Parser;
import kd.ebg.aqap.banks.gzc.dc.service.payment.company.CompanyPayQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CompanyPayImpl.class);

    public String pack(BankPayRequest bankPayRequest) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfoList.get(0);
        Element root = GZC_DC_Packer.packPayRoot(paymentInfo.getBankBatchSeqID(), this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PyAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PyAcctNm", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"ACCT_CCY_CD", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"Amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"TX_CNTPTY_ACCT_NUM", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"TXN_CNTPTY_NM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"TXN_CNTPTY_INST_ID", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"TXN_CNTPTY_INST_NM", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"IN_FLG", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = GZC_DC_Parser.parseINFO(root);
        Element head = root.getChild("Head");
        if (head != null) {
            String bankSequence = head.getChildTextTrim("E2BjnlNo");
            for (PaymentInfo info : paymentInfos) {
                info.setBankRefID(bankSequence);
            }
        }
        if (!"00000000".equalsIgnoreCase(response.getResponseCode())) {
            String errorMsg;
            if ("YQLT0003".equalsIgnoreCase(response.getResponseCode())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\uff0c\u5f52\u4e3a\u94f6\u884c\u5904\u7406\u4e2d\u72b6\u6001\uff0c\u7b49\u5f85\u67e5\u8be2\u4ed8\u6b3e\u8c03\u5ea6\u3002", (String)"CompanyPayImpl_11", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage());
                this.logger.info(errorMsg);
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_12", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)"", (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801%1$s\u3002", (String)"CompanyPayImpl_13", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), response.getResponseCode()));
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\uff0c\u7f6e\u4e3a\u5931\u8d25\u72b6\u6001\u3002", (String)"CompanyPayImpl_14", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage());
                this.logger.info(errorMsg);
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayImpl_15", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)"", (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801%1$s\u3002", (String)"CompanyPayImpl_13", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), response.getResponseCode()));
            }
        } else {
            Element body = root.getChild("Body");
            String state = body.getChildTextTrim("State");
            if ("0".equalsIgnoreCase(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_12", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)state, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"CompanyPayImpl_5", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]));
            } else if ("2".equalsIgnoreCase(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_12", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)state, (String)ResManager.loadKDString((String)"\u5f85\u94f6\u884c\u5ba1\u6838", (String)"CompanyPayImpl_6", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]));
            } else if ("1".equalsIgnoreCase(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayImpl_15", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)state, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"CompanyPayImpl_7", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]));
            } else if ("3".equalsIgnoreCase(state)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_12", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), (String)state, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"CompanyPayImpl_8", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)state, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5185\u5c42\u72b6\u6001\u7801%1$s\u3002", (String)"CompanyPayImpl_16", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), state));
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "null";
    }

    public String getBizCode() {
        return "10000002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613", (String)"CompanyPayImpl_10", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo);
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPayQueryImpl.class;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

