/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final PropertyConfigItem BJB_DC_PAYSALARYNO = PropertyConfigItem.builder().key("bjb_dc_PaySalaryNo ").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u4ee3\u7406\u5355\u4f4d\u7f16\u53f7", "BankBusinessConfig_0", "ebg-aqap-banks-bjb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3\u7684\u4ee3\u7406\u5355\u4f4d\u7f16\u53f7\uff0c\u4ee3\u53d1\u4e1a\u52a1\u65f6\u4f7f\u7528\u3002", "BankBusinessConfig_1", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u6d89\u53ca\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a", "BankBusinessConfig_34", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("CebankGZBatchPayNewOp\uff08paySalaryNo\uff09\u3002", "BankBusinessConfig_35", "ebg-aqap-banks-bjb-dc")})).isAccNo(true).build();
    private static final PropertyConfigItem BJB_DC_PAY_WAY_INTERFACE = PropertyConfigItem.builder().key("bjb_dc_pay_way_interface").mlName(new MultiLangEnumBridge("\u666e\u901a\u4ed8\u6b3e\u63a5\u53e3\u9009\u62e9", "BankBusinessConfig_2", "ebg-aqap-banks-bjb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u4ed8\u6b3e\u63a5\u53e3\u9009\u62e9\uff1a", "BankBusinessConfig_13", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("1)\u65e7\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3\uff1aCebankPayWithPrecontractOp\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_14", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("2)\u65b0\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3\uff1a\u5bf9\u516c\u5bf9\u79c1\u4ed8\u6b3e\u9009\u62e9\u65b0\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3CebankPayWithNewPrecontractOp\u3002", "BankBusinessConfig_15", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("3)\u5bf9\u516c\u8f6c\u8d26\u63a5\u53e3\uff0c\u5bf9\u79c1\u62a5\u9500\u63a5\u53e3\uff1a\u5bf9\u516c\u4ed8\u6b3e\u9009\u62e9\u65b0\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3CebankPayWithNewPrecontractOp\uff0c\u5bf9\u79c1\u4ed8\u6b3e\u9009\u62e9\u540c\u884c\u4ee3\u62a5\u9500\u63a5\u53e3CebankGZBatchPayNewJCOp\uff0c\u8de8\u884c\u4ee3\u53d1\u62a5\u9500\u63a5\u53e3CebankKHReimburseOp", "BankBusinessConfig_22", "ebg-aqap-banks-bjb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u65e7\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3", "BankBusinessConfig_6", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u65b0\u94f6\u4f01\u9884\u7ea6\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3", "BankBusinessConfig_7", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u5bf9\u516c\u8f6c\u8d26\u63a5\u53e3\uff0c\u5bf9\u79c1\u62a5\u9500\u63a5\u53e3", "BankBusinessConfig_23", "ebg-aqap-banks-bjb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"CebankPayWithPrecontractOp", "CebankPayWithNewPrecontractOp", "CebankKHReimburseOp"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"CebankPayWithPrecontractOp"})).mustInput(true).build();
    public static final PropertyConfigItem BJB_DC_IS_ADDKDFLAG = PropertyConfigItem.builder().key("bjb_dc_isAddKDFlagToPay").mlName(new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981\u8fdb\u884cKD\u6807\u8bb0", "BankBusinessConfig_8", "ebg-aqap-banks-bjb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981\u8fdb\u884cKD\u6807\u8bb0(\u6458\u8981\u4e2d\u52a0\u5165KD\u6807\u8bb0,\u533a\u5206\u4ed8\u6b3e\u662f\u5426\u7531\u94f6\u4f01\u53d1\u8d77):", "BankBusinessConfig_16", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("1)\u662f \uff1a\u652f\u4ed8\u65f6\u5728\u4ed8\u6b3e\u6458\u8981\u5c5e\u6027\u4e2d\u52a0\u5165KD\u6807\u8bb0\uff0c\u6458\u8981\u4e2d\u5c06\u663e\u793aKD\u6807\u8bb0\u5b57\u7b26\u4e32\uff1b\u4e1a\u52a1\u7cfb\u7edf\u5c06\u901a\u8fc7KD\u6807\u8bb0\u5c06\u4ed8\u6b3e\u5355\u636e\u4e0e\u4ea4\u6613\u660e\u7ec6\u5173\u8054\u3002", "BankBusinessConfig_17", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("2)\u5426 \uff1a\u5728\u652f\u4ed8\u65f6\u4e0d\u52a0\u5165KD\u6807\u8bb0\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_18", "ebg-aqap-banks-bjb-dc")})).mlSourceNames(mlFalseTrueCN).sourceValues(falseTrueEN).defaultValues(defaultFalse).mustInput(Boolean.TRUE.booleanValue()).type(BankPropertyConfigType.PAY_BIZ_PARAM.getName()).build();
    private static final PropertyConfigItem BJB_DC_DetailDesc = PropertyConfigItem.builder().key("detail_note_select").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c", "BankBusinessConfig_12", "ebg-aqap-banks-bjb-dc")).mlDesc(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c", "BankBusinessConfig_12", "ebg-aqap-banks-bjb-dc")).inputType(ConfigInputType.CLICK_TEXT.getInputType()).isHide(true).build();
    private static final PropertyConfigItem BATCH_PAY_SIZE = PropertyConfigItem.builder().key("batchPaySize").mlName(new MultiLangEnumBridge("\u6279\u91cf\u652f\u4ed8\u7b14\u6570", "BankBusinessConfig_24", "ebg-aqap-banks-bjb-dc")).mlDesc(new MultiLangEnumBridge("\u4ed8\u6b3e\u5355\u548c\u4ee3\u53d1\u5355\u5e76\u7b14\u652f\u4ed8\u7684\u6700\u5927\u7b14\u6570", "BankBusinessConfig_25", "ebg-aqap-banks-bjb-dc")).type(BankPropertyConfigType.PAY_BIZ_PARAM.getName()).set2Integer().set2MinValueNum(Integer.valueOf(1)).mustInput(true).defaultValues((List)Lists.newArrayList((Object[])new String[]{"60"})).build();
    private static final PropertyConfigItem BJB_DC_BALANCE_INTERFACE = PropertyConfigItem.builder().key("bjb_dc_balance_interface").mlName(new MultiLangEnumBridge("\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\u9009\u62e9", "BankBusinessConfig_26", "ebg-aqap-banks-bjb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u9009\u62e9\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u63a5\u53e3CebankQueryAllBalanceOp\u65f6\uff0c\u94f6\u884c\u8fd4\u56de\u53ea\u6709\u5b9e\u65f6\u4f59\u989d\uff1b", "BankBusinessConfig_27", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u9009\u62e9\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u63a5\u53e3CebankQueryBalanceOp\u65f6\uff0c\u94f6\u884c\u8fd4\u56de\u6709\u5b9e\u65f6\u4f59\u989d\u548c\u6628\u65e5\u4f59\u989d\uff1b", "BankBusinessConfig_28", "ebg-aqap-banks-bjb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("1\uff09\u6279\u91cf\u4f59\u989d\u67e5\u8be2\uff08CebankQueryAllBalanceOp\uff09\uff0c\u9ed8\u8ba4\u9009\u9879\uff1b", "BankBusinessConfig_29", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("2\uff09\u67e5\u8be2\u8d26\u6237\u4f59\u989d\uff08CebankQueryBalanceOp\uff09\uff1b", "BankBusinessConfig_30", "ebg-aqap-banks-bjb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"CebankQueryAllBalanceOp", "CebankQueryBalanceOp"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"CebankQueryAllBalanceOp"})).mustInput(true).build();

    public String getBankVersionID() {
        return "BJB_DC";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List list = this.getBankAddtionalPropertyConfigItems(true, false);
        list.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{BJB_DC_PAYSALARYNO, BJB_DC_PAY_WAY_INTERFACE, BJB_DC_IS_ADDKDFLAG, BJB_DC_DetailDesc, BATCH_PAY_SIZE, BJB_DC_BALANCE_INTERFACE}));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PropertyConfigItem propertyConfigItem = (PropertyConfigItem)iterator.next();
            if (!Objects.equals(propertyConfigItem.getKey(), "bank_area_code")) continue;
            iterator.remove();
        }
        BankBusinessConfig.specialAccNoTypeMl((List)list, (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankBusinessConfig_19", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u5f52\u96c6\u6237", "BankBusinessConfig_20", "ebg-aqap-banks-bjb-dc"), new MultiLangEnumBridge("\u5b9a\u671f\u6237", "BankBusinessConfig_21", "ebg-aqap-banks-bjb-dc")}), (List)Lists.newArrayList((Object[])new String[]{"normal", "collection", "fixed"}));
        return list;
    }

    public static boolean isAddKDFlagToPay() {
        return BJB_DC_IS_ADDKDFLAG.getCurrentValueAsBoolean();
    }

    public static String getPaySalaryNo(String payAccNo) {
        return BJB_DC_PAYSALARYNO.getCurrentValueWithObjectID(payAccNo);
    }

    public static boolean isCebankPayWithNewPrecontractOp() {
        return "CebankPayWithNewPrecontractOp".equalsIgnoreCase(BJB_DC_PAY_WAY_INTERFACE.getCurrentValue());
    }

    public static boolean isCebankPayWithPrecontractOp() {
        return "CebankPayWithPrecontractOp".equalsIgnoreCase(BJB_DC_PAY_WAY_INTERFACE.getCurrentValue());
    }

    public static boolean isCebankKHReimburseOp() {
        return "CebankKHReimburseOp".equalsIgnoreCase(BJB_DC_PAY_WAY_INTERFACE.getCurrentValue());
    }

    public static int getBatchPaySize() {
        return BATCH_PAY_SIZE.getCurrentValueAsInt();
    }

    public static boolean isCashPoolAcnt(String accNo) throws EBServiceException {
        return "fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo));
    }

    public static boolean isCollectAcnt(String accNo) throws EBServiceException {
        return "collection".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo));
    }

    public static boolean queryLastDayBalance() {
        return "CebankQueryBalanceOp".equalsIgnoreCase(BJB_DC_BALANCE_INTERFACE.getCurrentValue());
    }
}

