/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.service.BjbUtils;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ParserUtil {
    private static final List<String> EMPTY_LSIT = Lists.newArrayList((Object[])new String[]{"5J09", "F5J09"});
    private static final String DEBIT = ParserUtil.getDEBIT();
    private static final String CREDIT = ParserUtil.getCREDIT();
    private static final BigDecimal ZERO = new BigDecimal("0");

    private static String getDEBIT() {
        return ResManager.loadKDString((String)"\u8d37", (String)"ParserUtil_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    private static String getCREDIT() {
        return ResManager.loadKDString((String)"\u501f", (String)"ParserUtil_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public static BankResponse parserRep(Element root) {
        Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildTextNotNull((Element)req, (String)"retCode", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u8fd4\u56de\u7801retCode", (String)"ParserUtil_2", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        String msg = JDomUtils.getChildText((Element)req, (String)"errMsg");
        return new BankResponse(retCode, BjbUtils.getNullDefault(msg, ""));
    }

    public static EBBankDetailResponse parseDetail(BankDetailRequest request, String responseStr, boolean isHis) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        if (EMPTY_LSIT.contains(bankResponse.getResponseCode())) {
            return new EBBankDetailResponse(new ArrayList());
        }
        Preconditions.checkState((boolean)"0".equalsIgnoreCase(bankResponse.getResponseCode()), (Object)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801\uff1a%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"ParserUtil_22", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        Element opReq = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element resultSet = JDomUtils.getChildElementNotNull((Element)opReq, (String)"opResultSet");
        Element acctResult = JDomUtils.getChildElementNotNull((Element)opReq, (String)"opResult");
        String acctName = JDomUtils.getChildTextNotNull((Element)acctResult, (String)"acctName");
        List result = resultSet.getChildren("opResult");
        ArrayList detailInfos = Lists.newArrayListWithCapacity((int)result.size());
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        String bankCurrency = request.getBankCurrency();
        result.forEach(element -> {
            String dateNetSerial;
            String cur = JDomUtils.getChildText((Element)((Element)element), (String)"accountCur");
            String amount = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"amount");
            String docFlag = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"dOcFlag");
            String balanceStr = JDomUtils.getChildText((Element)((Element)element), (String)"balance");
            String otherAcct = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"otherAcct");
            String otherAcctName = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"otherAcctName");
            String othersideBank = JDomUtils.getChildText((Element)((Element)element), (String)"otherSideBank");
            String transTime = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"transTime");
            transTime = Strings.padStart((String)transTime, (int)6, (char)'0');
            String userRem = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"userRem");
            String bankDetailNo = dateNetSerial = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"dateNetSerial");
            dateNetSerial = dateNetSerial.substring(0, 8);
            BigDecimal decimal = BjbUtils.str2BigDecimal(amount);
            BigDecimal balance = BjbUtils.str2BigDecimal(balanceStr);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(request.getAcnt().getAccNo());
            detailInfo.setAccName(acctName);
            detailInfo.setCurrency(StringUtils.isEmpty((String)cur) ? bankCurrency : cur);
            if (DEBIT.equalsIgnoreCase(docFlag)) {
                detailInfo.setDebitAmount(ZERO);
                detailInfo.setCreditAmount(decimal);
            } else if (CREDIT.equalsIgnoreCase(docFlag)) {
                detailInfo.setCreditAmount(ZERO);
                detailInfo.setDebitAmount(decimal);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u9519\u8bef\u7684\u501f\u8d37\u6807\u5fd7(docFlag):%s\u3002", (String)"ParserUtil_23", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), docFlag));
            }
            detailInfo.setOppAccNo(otherAcct);
            detailInfo.setOppAccName(otherAcctName);
            detailInfo.setExplanation(userRem);
            if (isHis) {
                Preconditions.checkNotNull((Object)othersideBank, (Object)EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5bf9\u65b9\u884c\u884c\u540dotherSideBank\u4e3a\u7a7a\u3002", (String)"ParserUtil_8", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0])));
                detailInfo.setBalance(balance);
                detailInfo.setOppBankName(othersideBank);
            }
            try {
                detailInfo.setTransDate(BjbUtils.parseDate(dateNetSerial));
                detailInfo.setTransTime(BjbUtils.parseDateTime(dateNetSerial + transTime));
            }
            catch (DateTimeParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u65e5\u671f\u9519\u8bef\u3002", (String)"ParserUtil_9", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String summary = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"summary");
            if (!StringUtils.isEmpty((String)summary) && summary.contains("_KD_")) {
                if (summary.contains("TS@")) {
                    detailInfo.setTransType("TRUE");
                }
                String bankDetailSeqId = BizNoUtil.getId((String)summary);
                detailInfo.setPayBankDetailSeqID(bankDetailSeqId);
                String KDDetailNo = BizNoUtil.getId((String)summary);
                detailInfo.setKdFlag(KDDetailNo);
                String note = BizNoUtil.getMsg((String)summary);
                detailInfo.setUseCn(note);
            }
            if (StringUtils.isNotEmpty((String)userRem) && userRem.contains("_KD_")) {
                String KDDetailNo = BizNoUtil.getId((String)userRem);
                detailInfo.setPayBankDetailSeqID(KDDetailNo);
                detailInfo.setKdFlag(KDDetailNo);
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData((Element)element);
            detailInfo.setJsonMap(jsonStr);
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfo.setBankDetailNo(bankDetailNo);
            detailInfos.add(detailInfo);
        });
        return new EBBankDetailResponse((List)detailInfos);
    }

    public static EBBankPayResponse parsePayResponse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        String code = bankResponse.getResponseCode();
        String message = bankResponse.getResponseMessage();
        List paymentInfos = request.getPaymentInfos();
        if ("0".equalsIgnoreCase(code)) {
            String result;
            Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getChildElementNotNull((Element)req, (String)"opResult");
            switch (result = JDomUtils.getChildTextNotNull((Element)opResult, (String)"result")) {
                case "3": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)message);
                    break;
                }
                case "1": 
                case "4": 
                case "2": 
                case "11": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserUtil_11", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                default: {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)result, (String)message);
                    break;
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parsePayQueryResponse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        String code = bankResponse.getResponseCode();
        String message = bankResponse.getResponseMessage();
        List paymentInfos = request.getPaymentInfos();
        if ("0".equalsIgnoreCase(code)) {
            String result;
            Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getChildElementNotNull((Element)req, (String)"opResult");
            switch (result = JDomUtils.getChildTextNotNull((Element)opResult, (String)"result")) {
                case "": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u65e0\u6b64\u6307\u4ee4", (String)"ParserUtil_14", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"ParserUtil_15", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)message);
                    break;
                }
                case "0": 
                case "1": 
                case "2": 
                case "11": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserUtil_11", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                default: {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)result, (String)message);
                    break;
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseSalaryResponse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        String code = bankResponse.getResponseCode();
        String message = bankResponse.getResponseMessage();
        List paymentInfos = request.getPaymentInfos();
        if ("0".equalsIgnoreCase(code)) {
            String result;
            Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getChildElementNotNull((Element)req, (String)"opResult");
            switch (result = JDomUtils.getChildTextNotNull((Element)opResult, (String)"result")) {
                case "4": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)message);
                    break;
                }
                case "3": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserUtil_11", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                default: {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)result, (String)message);
                    break;
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseSalaryQueryResponse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        block18: {
            String message;
            String code;
            block17: {
                String payStat;
                Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
                BankResponse bankResponse = ParserUtil.parserRep(root);
                code = bankResponse.getResponseCode();
                message = bankResponse.getResponseMessage();
                paymentInfos = request.getPaymentInfos();
                if (!"0".equalsIgnoreCase(code)) break block17;
                Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
                Element opResult = JDomUtils.getChildElementNotNull((Element)req, (String)"opResult");
                switch (payStat = JDomUtils.getChildTextNotNull((Element)opResult, (String)"payStat")) {
                    case "4": {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)code, (String)message);
                        break;
                    }
                    case "3": {
                        Element opResultSet = JDomUtils.getChildElementNotNull((Element)req, (String)"opResultSet");
                        List opResults = opResultSet.getChildren("opResult");
                        Map<String, PaymentInfo> paymentMap = ParserUtil.createPaymentMap(paymentInfos);
                        for (int i = 0; i < opResults.size(); ++i) {
                            Element tranResult = (Element)opResults.get(i);
                            String orderNo = JDomUtils.getChildTextNotNull((Element)tranResult, (String)"orderNo");
                            String result = JDomUtils.getChildTextNotNull((Element)tranResult, (String)"result");
                            String bankRem = JDomUtils.getChildTextNotNull((Element)tranResult, (String)"bankRem");
                            PaymentInfo info = paymentMap.get(orderNo);
                            if ("4".equalsIgnoreCase(result)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)result, (String)bankRem);
                                continue;
                            }
                            if ("3".equalsIgnoreCase(payStat) || "7".equalsIgnoreCase(payStat) || "8".equalsIgnoreCase(payStat) || "9".equalsIgnoreCase(result) || "10".equalsIgnoreCase(result)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)bankRem);
                                continue;
                            }
                            if ("0".equalsIgnoreCase(payStat) || "1".equalsIgnoreCase(payStat) || "2".equalsIgnoreCase(payStat)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)bankRem);
                                continue;
                            }
                            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)result, (String)bankRem);
                        }
                        break block18;
                    }
                    case "0": 
                    case "1": 
                    case "2": 
                    case "6": {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)code, (String)message);
                        break;
                    }
                    default: {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
                    }
                }
                break block18;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static Map<String, PaymentInfo> createPaymentMap(List<PaymentInfo> paymentInfos) {
        HashMap<String, PaymentInfo> infoMap = new HashMap<String, PaymentInfo>(paymentInfos.size());
        paymentInfos.forEach(paymentInfo -> infoMap.put(paymentInfo.getBankSerialNo(), (PaymentInfo)paymentInfo));
        return infoMap;
    }
}

