/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.balance;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead("CebankQueryAllBalanceOp", Sequence.genSequence());
        List acntList = request.getBankAcntList();
        JDomUtils.addChild((Element)head, (String)"queryNum", (String)String.valueOf(acntList.size()));
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        Element reqSet = JDomUtils.addChild((Element)param, (String)"opReqSet");
        acntList.forEach(acnt -> JDomUtils.addChild((Element)JDomUtils.addChild((Element)reqSet, (String)"opRequest"), (String)"accountNo", (String)acnt.getAccNo()));
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, "CebankQueryAllBalanceOp");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        Preconditions.checkState((boolean)"0".equalsIgnoreCase(bankResponse.getResponseCode()), (Object)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:[%1$s],\u9519\u8bef\u4fe1\u606f\uff1a[%2$s]", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        Element opReq = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element resultSet = JDomUtils.getChildElementNotNull((Element)opReq, (String)"opResultSet");
        List result = resultSet.getChildren("opResult");
        ArrayList balanceInfos = Lists.newArrayListWithCapacity((int)result.size());
        result.forEach(element -> {
            BankAcnt acnt = new BankAcnt();
            BalanceInfo balanceInfo = new BalanceInfo();
            String balance = JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"Balance");
            acnt.setAccNo(JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"Acct"));
            acnt.setAccName(JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"AcctName"));
            balance = balance.replaceAll(",", "");
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setBankCurrency(JDomUtils.getChildTextNotNull((Element)((Element)element), (String)"acctCur"));
            balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
            balanceInfo.setAvailableBalance(new BigDecimal(balance));
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfos.add(balanceInfo);
        });
        return new EBBankBalanceResponse((List)balanceInfos);
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "CebankQueryAllBalanceOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u67e5\u8be2\u4f59\u989d", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, false);
    }

    public boolean match(BankBalanceRequest request) {
        return !BankBusinessConfig.isCollectAcnt(request.getAcnt().getAccNo()) && !BankBusinessConfig.queryLastDayBalance();
    }
}

