/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.login;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginPacker;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginParser;
import kd.ebg.aqap.banks.bjb.dc.service.sign.SignHelper;
import kd.ebg.aqap.business.login.AbstractLoginImpl;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class LoginImpl
extends AbstractLoginImpl {
    EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    public static String LOGIN_URL = "/servlet/com.bccb.inbs.api.servlet.APISessionReqServlet";
    private static final int SESSION_TIMEOUT = 180;
    private static volatile LoginImpl instance;

    public String pack() {
        String packLogin = LoginPacker.packLogin();
        String sign = SignHelper.sign(packLogin);
        String requestStr = "netType=3&reqData=" + sign;
        this.log.infoPrivacy("\u5317\u4eac\u94f6\u884c\u6267\u884c\u767b\u5f55url:, " + LOGIN_URL + "\u8bf7\u6c42\u62a5\u6587\uff1a\n " + requestStr);
        RequestContextUtils.setRunningParam((String)"length", (String)Integer.toString(requestStr.length()));
        return requestStr;
    }

    public String parse(String loginRec) {
        return LoginParser.parser(loginRec);
    }

    public String getConnectionURI() {
        return LOGIN_URL;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(LOGIN_URL);
        factory.setHttpHeader("User-Agent", "API");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Length", RequestContextUtils.getRunningParam((String)"length"));
        return factory;
    }

    public int getTimeout() {
        return 180;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginImpl getInstance() {
        if (instance != null) return instance;
        Class<LoginImpl> clazz = LoginImpl.class;
        synchronized (LoginImpl.class) {
            if (instance != null) return instance;
            instance = new LoginImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private String getTokenKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        return "eb_bjb" + customID + "_" + bankLoginID + "_token";
    }

    public void configFactoryForSession(ConnectionFactory factory, boolean needNew) {
        try {
            factory.setHttpHeader("User-Agent", "API");
            factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
            String sessionId = this.getSession(needNew);
            factory.setUri("/servlet/com.bccb.inbs.api.servlet.APIReqServlet?dse_sessionId=" + sessionId);
        }
        catch (EBServiceException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u5f55\u83b7\u53d6dse_sessionId\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LoginImpl_2", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private String getSession() {
        return this.getSession(false);
    }

    private String getSession(boolean newSession) {
        if (newSession) {
            this.clearToken();
        }
        LoginImpl login = LoginImpl.getInstance();
        String sessionId = login.doBiz();
        return sessionId;
    }

    public void clearToken() {
        CosmicCache.delete((String)this.getTokenKey());
    }
}

