/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.payment.pay;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.BjbUtils;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.banks.bjb.dc.service.payment.pay.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, true);
    }

    public int getBatchSize() {
        return 60;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return PayImpl.packPay(bankPayRequest, "CebankKHReimburseOp");
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return PayImpl.parseResponse(bankPayRequest, s);
    }

    public String getDeveloper() {
        return null;
    }

    public static String packPay(BankPayRequest request, String opName) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead(opName, paymentInfo.getBankBatchSeqId());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"payDepAcc", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)param, (String)"precontractTime", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)param, (String)"totalNum", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)param, (String)"totalAmt", (String)BjbUtils.bigDecimal2Str(paymentInfo.getTotalAmount()));
        JDomUtils.addChild((Element)param, (String)"currencyType", (String)"01");
        JDomUtils.addChild((Element)param, (String)"hideFlag", (String)"1");
        JDomUtils.addChild((Element)param, (String)"reqReserved1", (String)"");
        JDomUtils.addChild((Element)param, (String)"reqReserved2", (String)"");
        Element opReqSet = JDomUtils.addChild((Element)param, (String)"opReqSet");
        int len = paymentInfos.size();
        for (int i = 0; i < len; ++i) {
            Element opRequest = JDomUtils.addChild((Element)opReqSet, (String)"opRequest");
            JDomUtils.addChild((Element)opRequest, (String)"orderNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankSerialNo());
            JDomUtils.addChild((Element)opRequest, (String)"recPerAcc", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)opRequest, (String)"recPerName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)opRequest, (String)"certType", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"certNum", (String)"");
            String bankName = ((PaymentInfo)paymentInfos.get(i)).getIncomeBankName();
            JDomUtils.addChild((Element)opRequest, (String)"recBankName", (String)bankName);
            SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
            String recBankNo = settBankKeyWordsRepository.matchBankNoByKey(bankName);
            if (StringUtils.isEmpty((String)recBankNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u94f6\u884c%s\u7684\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7,\u8bf7\u5728\u6e05\u7b97\u884c\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u6e05\u7b97\u884c\u53f7", (String)"PayImpl_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), bankName));
            }
            JDomUtils.addChild((Element)opRequest, (String)"recBankNo", (String)recBankNo);
            JDomUtils.addChild((Element)opRequest, (String)"payAmt", (String)BjbUtils.bigDecimal2Str(((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)opRequest, (String)"userRem", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"reqDetail1", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"reqDetail2", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"reqDetail3", (String)"");
        }
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, opName, true);
    }

    public static EBBankPayResponse parseResponse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        String code = bankResponse.getResponseCode();
        String message = bankResponse.getResponseMessage();
        List paymentInfos = request.getPaymentInfos();
        if ("0".equalsIgnoreCase(code)) {
            String result;
            Element req = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getChildElementNotNull((Element)req, (String)"opResult");
            switch (result = JDomUtils.getChildTextNotNull((Element)opResult, (String)"result")) {
                case "4": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)message);
                    break;
                }
                case "3": {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserUtil_11", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
                    break;
                }
                default: {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)result, (String)message);
                    break;
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getBizCode() {
        return "CebankKHReimburseOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u4ee3\u53d1\u62a5\u9500", (String)"PayImpl_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType()) && BankBusinessConfig.isCebankKHReimburseOp() && paymentInfo.is2Individual() && !paymentInfo.is2SameBank();
    }
}

