/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000001;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000002;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000003;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000004;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000006;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000019;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000024;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000025;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.OPCB000063;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class Packer {
    public static Map getSendObject(Object rqst, String transCode) throws Exception {
        Root<Header4Send, Object> root;
        if ("OPCB000003".equals(transCode) && rqst instanceof BankBalanceRequest) {
            root = OPCB000003.getInstance().getSendRoot((BankBalanceRequest)rqst);
        } else if ("OPCB000063".equals(transCode) && rqst instanceof BankBalanceRequest) {
            root = OPCB000063.getInstance().getSendRoot((BankBalanceRequest)rqst);
        } else if ("OPCB000024".equals(transCode) && rqst instanceof BankDetailRequest) {
            root = OPCB000024.getInstance().getSendRoot((BankDetailRequest)rqst);
        } else if ("OPCB000001".equals(transCode) && rqst instanceof List) {
            root = OPCB000001.getInstance().getSendRoot((List)rqst);
        } else if ("OPCB000025".equals(transCode) && rqst instanceof List) {
            root = OPCB000025.getInstance().getSendRoot((List)rqst);
        } else if ("OPCB000002".equals(transCode) && rqst instanceof List) {
            root = OPCB000002.getInstance().getSendRoot((List)rqst);
        } else if ("OPCB000004".equals(transCode) && rqst instanceof List) {
            root = OPCB000004.getInstance().getSendRoot((List)rqst);
        } else if ("OPCB000006".equals(transCode) && rqst instanceof List) {
            root = OPCB000006.getInstance().getSendRoot((List)rqst);
        } else if ("OPCB000019".equals(transCode) && rqst instanceof List) {
            root = OPCB000019.getInstance().getSendRoot((List)rqst);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format("%s;%s", transCode, ResManager.loadKDString((String)"\u4ea4\u6613\u7801\u6709\u8bef\uff0c\u8bf7\u4fee\u6539", (String)"Packer_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0])));
        }
        root = Packer.setHeader4Send(root, transCode);
        JSONObject headJsonObject = (JSONObject)JSONObject.toJSON(root.getHeader());
        Map headMap = (Map)JSONObject.toJavaObject((JSON)headJsonObject, Map.class);
        JSONObject bodyJsonObject = (JSONObject)JSONObject.toJSON((Object)root.getBody());
        Map bodyMap = (Map)JSONObject.toJavaObject((JSON)bodyJsonObject, Map.class);
        bodyMap.putAll(headMap);
        return bodyMap;
    }

    public static Root setHeader4Send(Root root, String transCode) throws Exception {
        Header4Send header = new Header4Send();
        header.setCONSUMER_SEQ_NO(Sequence.gen18Sequence());
        header.setHOST_NO(RequestContextUtils.getBankParameterValue((String)"HOST_NO"));
        header.setSERVICE_CODE(transCode);
        header.setTRAN_DATE(LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        header.setTRAN_TIMESTAMP(Packer.getTimeStr(LocalDateTime.now()));
        root.setHeader(header);
        return root;
    }

    public static String getTimeStr(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return formatter.format(dateTime);
    }
}

