/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000006_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000006_ReceiveItem;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000006_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.constants.BSZConstants;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000006
implements IMiniService<Root<Header4Send, OPCB000006_Send>, Root<Header4Receive, OPCB000006_Receive>, List<PaymentInfo>, List<PaymentInfo>> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000006.class);
    public static String transCode = "OPCB000006";

    public static OPCB000006 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000006_Send> getSendRoot(List<PaymentInfo> paymentInfos) throws Exception {
        Root<Header4Send, OPCB000006_Send> root = new Root<Header4Send, OPCB000006_Send>();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        OPCB000006_Send body = new OPCB000006_Send();
        String BATCH_NO = paymentInfo.getBankRefID();
        if (StringUtils.isEmpty((String)BATCH_NO)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u636e\u65e0\u6279\u6b21\u53f7\uff0c\u65e0\u6cd5\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001", (String)"OPCB000006_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        body.setTRAN_FLOWNO(BATCH_NO);
        body.setPAGE_ROW_COUNT("20");
        body.setCURRENT_PAGE("1");
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000006_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000006_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<PaymentInfo> recvStrategy(Root<Header4Receive, OPCB000006_Receive> root, List<PaymentInfo> paymentInfos) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000006_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"body\u8282\u70b9\u4e0d\u5b58\u5728", (String)"OPCB000006_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000006_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000006_ReceiveItem> items = body.getSALARYDETAIL_ARRAY();
        for (OPCB000006_ReceiveItem item : items) {
            String bodyStatusCode;
            String bodyStatusExpr;
            PaymentInfo info = Utils.selectPaymentrInfoFromBatch(paymentInfos, item.getOLD_ORDER_FLOWNO());
            if (info == null) {
                logger.error("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5339\u914d\u7684\u6d41\u6c34,\u5bf9\u5e94\u7684\u8fd9\u7b14\u4ea4\u6613\u53ef\u80fd\u662f\u4ea4\u6613\u6210\u529f\u6216\u8005\u5931\u8d25\uff1a" + item.getOLD_ORDER_FLOWNO());
                continue;
            }
            String ORDER_FLOWNO = Utils.nullAsBlank(item.getORDER_FLOWNO());
            if (!StringUtils.isEmpty((String)ORDER_FLOWNO)) {
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)"ORDER_FLOWNO", (String)ORDER_FLOWNO);
            }
            if (StringUtils.isEmpty((String)(bodyStatusExpr = Utils.nullAsBlank(BSZConstants.STATUS_MAP.get(bodyStatusCode = Utils.nullAsBlank(item.getORDER_STATE())))))) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522b\u72b6\u6001\u7801:%s", (String)"OPCB000006_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode), (String)headStatusCode, (String)headStatusMsg);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522bbody\u72b6\u6001\u7801\uff1a%s", (String)"OPCB000006_4", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode));
            }
            String statusMsg = Utils.nullAsBlank(item.getFAIL_REASON());
            if (bodyStatusCode.equals("90")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
                continue;
            }
            if (bodyStatusCode.equals("91")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
        }
        return paymentInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    private static class Holder {
        private static final OPCB000006 instance = new OPCB000006();

        private Holder() {
        }
    }
}

