/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uobsg.dc.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uobsg.dc.MetaDataImpl;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Helper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Helper.class);
    private static Map<String, String> transCode = new HashMap<String, String>(16);

    public static String transType(String code) {
        return code == null ? "" : transCode.getOrDefault(code, code);
    }

    public static synchronized String getDDMMNNN() {
        try {
            String date = LocalDate.now().format(DateTimeFormatter.ofPattern("ddMM"));
            String seqNo3 = Sequence.getAutoincrementNumber((int)3);
            logger.info("SeqNo->{}", (Object)seqNo3);
            return date + seqNo3;
        }
        catch (EBServiceException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4eca\u65e5\u751f\u6210\u4ed8\u6b3e\u6587\u4ef6\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u5df2\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u540d\u4e0d\u91cd\u590d\u7684\u6587\u4ef6\uff01", (String)"Helper_1", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]));
        }
    }

    public static String getFileName() {
        String prefix = RequestContextUtils.getBankParameterValue((String)MetaDataImpl.pay_file_name);
        String fileName = StringUtils.isNotEmpty((String)prefix) ? prefix + Helper.getDDMMNNN() + ".xml.pgp" : Helper.getDDMMNNN() + ".xml.pgp";
        return fileName;
    }

    public void addressSplit(Element Cdtr_PstlAdr, String address, Namespace ns1) {
        this.addressSplit(Cdtr_PstlAdr, address, ns1, 3);
    }

    public void addressSplit(Element Cdtr_PstlAdr, String address, Namespace ns1, int lines) {
        if (StringUtils.isEmpty((String)address)) {
            return;
        }
        List<String> strList = Helper.getStrList(address, 35);
        if (strList.size() > lines) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u5730\u5740\u8fc7\u957f", (String)"Helper_2", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]));
        }
        for (String str : strList) {
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"AdrLine", (String)str.trim()).setNamespace(ns1);
        }
    }

    public String formatStringByLength(String message, Integer length) {
        if (StringUtils.isEmpty((String)message) && message.length() > length) {
            message = message.substring(0, length);
        }
        return message;
    }

    public static List<String> getStrList(String inputString, int length) {
        int size = inputString.length() / length;
        if (inputString.length() % length != 0) {
            ++size;
        }
        return Helper.getStrList(inputString, length, size);
    }

    public static List<String> getStrList(String inputString, int length, int size) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (int index = 0; index < size; ++index) {
            String childStr = Helper.substring(inputString, index * length, (index + 1) * length);
            list.add(childStr);
        }
        return list;
    }

    public static String substring(String str, int f, int t) {
        if (f > str.length()) {
            return null;
        }
        if (t > str.length()) {
            return str.substring(f);
        }
        return str.substring(f, t);
    }

    public static String convert2PurposeCode(PaymentInfo paymentInfo, String interfaceCode) {
        String exp = paymentInfo.getExplanation();
        String customId = EBContext.getContext().getCustomID();
        String bankVersion = "UOBSG_DC";
        return UseKeyWordService.getUseByKey((String)customId, (String)exp, (String)interfaceCode, (String)"BEXP", (String)bankVersion);
    }

    public static void fetchPayments(String bankBatchSeqID, DetailInfo detailInfo) {
        List paymentInfoList = PaymentInfoService.getInstance().selectByBankBatchSeqID(bankBatchSeqID);
        if (paymentInfoList == null || paymentInfoList.size() != 1) {
            return;
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfoList.get(0);
        detailInfo.setOppBankName(paymentInfo.getIncomeBankName());
        detailInfo.setOppAccName(paymentInfo.getIncomeAccName());
        detailInfo.setOppAccNo(paymentInfo.getIncomeAccNo());
    }

    static {
        transCode.put("NCHK", "Cheque");
        transCode.put("NIBG", "Interbank GIRO");
        transCode.put("NNET", "NETS Transaction");
        transCode.put("NATM", "ATM");
        transCode.put("NCSH", "Cash Deposit");
        transCode.put("NCDM", "Cash Deposit via CDM");
        transCode.put("NIFT", "Inter-Account / Bank Fund Transfer via Internet Banking");
        transCode.put("NBLK", "Bulk CO / Cheque");
        transCode.put("NLMS", "Liquidity Management");
        transCode.put("NINT", "Interest");
        transCode.put("NTRF", "Transfer");
        transCode.put("NIBF", "Interbank FAST");
        transCode.put("NSVC", "Service Charge");
        transCode.put("NPEN", "Penalty");
        transCode.put("NOTT", "Overseas TT");
    }
}

