/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scb.h2h.service.payment.company;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Packer;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Parser;
import kd.ebg.aqap.banks.scb.h2h.service.payment.company.QueryPayImpl;
import kd.ebg.aqap.banks.scb.h2h.service.payment.util.ScbUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "BATCH_PAY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u652f\u4ed8", (String)"PayImpl_0", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !"overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element simulator = new Element("simulator");
        Element head = SCBH2H_Packer.createHead("BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[i]);
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"acntNo", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)list, (String)"acntName", (String)paymentInfos[i].getAccName());
            JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
            JDomUtils.addChild((Element)list, (String)"acntBankName", (String)paymentInfos[i].getBankName());
            JDomUtils.addChild((Element)list, (String)"acntCountry", (String)paymentInfos[i].getAccCountry());
            JDomUtils.addChild((Element)list, (String)"acntProvince", (String)paymentInfos[i].getAccProvince());
            JDomUtils.addChild((Element)list, (String)"acntCity", (String)paymentInfos[i].getAccCity());
            JDomUtils.addChild((Element)list, (String)"acntBankBranchNo", (String)paymentInfos[i].getAreaCode());
            JDomUtils.addChild((Element)list, (String)"acntBankCnapsNo", (String)"");
            JDomUtils.addChild((Element)list, (String)"currency", (String)paymentInfos[i].getCurrency());
            Date now = new Date();
            JDomUtils.addChild((Element)list, (String)"startDate", (String)DateTimeUtils.format((Date)now, (String)"yyyyMMdd"));
            JDomUtils.addChild((Element)list, (String)"startTime", (String)DateTimeUtils.format((Date)now, (String)"HHmmss"));
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)list, (String)"txAmt", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getAmount()));
            JDomUtils.addChild((Element)list, (String)"urgentFlag", (String)(paymentInfos[i].is2Urgent() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameBankFlag", (String)(paymentInfos[i].is2SameBank() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameCityFlag", (String)(paymentInfos[i].is2SameCity() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"payType", (String)(paymentInfos[i].is2Individual() ? "individual" : "company"));
            JDomUtils.addChild((Element)list, (String)"email", (String)paymentInfos[i].getEmails());
            JDomUtils.addChild((Element)list, (String)"oppAcntNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)list, (String)"oppAcntName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)list, (String)"oppAcntNameEN", (String)"");
            JDomUtils.addChild((Element)list, (String)"oppBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)list, (String)"oppAcntCountry", (String)paymentInfos[i].getIncomeCountry());
            JDomUtils.addChild((Element)list, (String)"oppAcntProvince", (String)paymentInfos[i].getIncomeProvince());
            JDomUtils.addChild((Element)list, (String)"oppAcntCity", (String)paymentInfos[i].getIncomeCity());
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)paymentInfos[i].getIncomeAreaCode());
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)paymentInfos[i].getIncomeAreaCode());
            String benefitBankAddress = paymentInfos[i].getIncomeBankAddress();
            JDomUtils.addChild((Element)list, (String)"benefitBankAddress", (String)benefitBankAddress);
            if (PropertiesConstants.getValue((String)"CHINA").equalsIgnoreCase(paymentInfos[i].getAccCountry()) && "CNY".equalsIgnoreCase(paymentInfos[i].getCurrency())) {
                JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)paymentInfos[i].getIncomeCnaps());
            } else {
                JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)paymentInfos[i].getIncomeSwiftCode());
            }
            JDomUtils.addChild((Element)list, (String)"useCode", (String)"");
            String explanation = paymentInfos[i].getExplanation();
            if (!StringUtils.isEmpty((String)paymentInfos[i].getExplanation()) && paymentInfos[i].getExplanation().length() > 30) {
                explanation = paymentInfos[i].getExplanation().substring(0, 30);
            }
            JDomUtils.addChild((Element)list, (String)"explanation", (String)explanation);
            if (SCBH2H_Packer.isContainsStrangeStr(paymentInfos[i].getIncomeAccNo())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\uff0c\u4e0d\u80fd\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff1a ~ ! @ # $ % ^ & * _ { } \" ` = [ ] ;", (String)"PayImpl_1", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)list, (String)"payPurpose", (String)ScbUtils.getPodCodeByExplanation(explanation));
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = SCBH2H_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String sequence = JDomUtils.getChildTextTrim((Element)list, (String)"sequence");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)sequence);
            if (null == info) continue;
            if ("BCC_PAY_SUBMT_SUCCESS".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

