/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tccb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tccb.dc.utils.TCommon;
import kd.ebg.aqap.banks.tccb.dc.utils.TPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "B2eQueryBalanceInfo";
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String userPassword = RequestContextUtils.getBankParameterValue((String)"userPassword");
        String operatorID = RequestContextUtils.getBankParameterValue((String)"operatorID");
        Date now = new Date();
        String d = DateTimeUtils.format((Date)now, (String)"yyyy-MM-dd'T'HH:mm:ss");
        Element transaction = TPacker.createCommonHead(tr_code, userID, userPassword, operatorID, req_no, "1", d);
        Element RequestBody = JDomUtils.addChild((Element)transaction, (String)"RequestBody");
        Element RequestRecord = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)RequestRecord, (String)"AcctNo", (String)acnt.getAccNo());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)transaction, (String)encoding);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element transaction = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element RespondHeader = transaction.getChild("RespondHeader");
        BankResponse response = TCommon.parseBankResponse(RespondHeader);
        if (!"0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String respondTime = RespondHeader.getChildTextTrim("respondTime");
        Element RespondBody = transaction.getChild("RespondBody");
        Element RespondRecord = RespondBody.getChild("RespondRecord");
        String Currency = RespondRecord.getChildTextTrim("PP0490");
        String Balance = RespondRecord.getChildTextTrim("PP0040");
        String AvailableBalance = RespondRecord.getChildTextTrim("PP0050");
        String lastDayBalance = RespondRecord.getChildTextTrim("PP0060");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(Currency);
        try {
            balanceInfo.setBalanceDateTime(LocalDateTime.parse(respondTime, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1arespondTime\u65e0\u6cd5\u89e3\u6790\uff0c%1$s\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), respondTime), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)Balance)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getBalanceEmptyTips((String)"PP0040"));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(Balance));
        if (!StringUtils.isEmpty((String)AvailableBalance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(AvailableBalance));
        }
        if (!StringUtils.isEmpty((String)lastDayBalance)) {
            balanceInfo.setLastDayAvlBalance(new BigDecimal(lastDayBalance));
        }
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(16);
        balanceInfoList.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u4f59\u989d", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = TCommon.getEncoding();
        factory.setUri(TPacker.getHttpUrl("balance"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
    }
}

