/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice.boot.services;

import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BankInfo;
import kd.ebg.aqap.common.model.repository.BankInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.log.EBGLogger;

@Service
public class BankUsedInfoService {
    static EBGLogger log = EBGLogger.getInstance().getLogger(BankUsedInfoService.class);
    private final BankInfoRepository bankInfoRepository;

    public BankUsedInfoService(BankInfoRepository bankInfoRepository) {
        this.bankInfoRepository = bankInfoRepository;
    }

    public BankInfo[] getAllUsedBanks() {
        return this.bankInfoRepository.findAll().toArray(new BankInfo[0]);
    }

    public static BankUsedInfoService getInstance() {
        return (BankUsedInfoService)SpringContextUtil.getBean(BankUsedInfoService.class);
    }

    public void addUsedBank(String customId, String bankLoginId) {
        try {
            BankInfo bankUsedInfo = new BankInfo();
            String id = Sequence.genSequence();
            bankUsedInfo.setId(id);
            bankUsedInfo.setBankLoginId(bankLoginId);
            bankUsedInfo.setModuleName("QUERY_PAY");
            bankUsedInfo.setCustomId(customId);
            bankUsedInfo.setVerifyCode(bankUsedInfo.genVerifyCode());
            this.bankInfoRepository.save(bankUsedInfo);
        }
        catch (Exception e) {
            log.info("\u66f4\u65b0\u5df2\u4f7f\u7528\u94f6\u884c\u4fe1\u606f\u51fa\u9519!!!" + e);
        }
    }
}

