/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.aqap.common.framework.exception.EBBaseException;
import kd.ebg.aqap.common.utils.ClassUtil;
import kd.ebg.aqap.mservice.impl.BaseService;
import kd.ebg.aqap.mservice.lang.MultiLang;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequestEnhance;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class CustomizeService
extends BaseService
implements IBillWebApiPlugin {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CustomizeService.class);
    public static Map<String, Map<String, Class>> customizeMethodCache = new HashMap<String, Map<String, Class>>(16);

    public static void addCustomizeMethodCache(String context) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)context);
            for (String key : jsonObject.keySet()) {
                if (customizeMethodCache.containsKey(key)) continue;
                try {
                    HashMap<String, Class> subCache = new HashMap<String, Class>(16);
                    JSONObject handler = jsonObject.getJSONObject(key);
                    String methodClassName = handler.getString("methodClass");
                    String requestClassName = handler.getString("requestClass");
                    String responseClassName = handler.getString("responseClass");
                    Class methodClass = ClassUtil.loadClass((String)methodClassName);
                    Class requestClass = ClassUtil.loadClass((String)requestClassName);
                    Class responseClass = ClassUtil.loadClass((String)responseClassName);
                    subCache.put("methodClass", methodClass);
                    subCache.put("requestClass", requestClass);
                    subCache.put("responseClass", responseClass);
                    customizeMethodCache.put(key, subCache);
                }
                catch (Throwable e) {
                    logger.error("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6d41\u7a0b\u5931\u8d25\uff1a{}", new Object[]{e.toString()});
                }
            }
        }
        catch (Exception e) {
            logger.error("\u626b\u63cf\u63d2\u4ef6\u5305\u51fa\u9519\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        return this.service(params);
    }

    @Override
    EBResponse doBiz(String data, EBRequestEnhance ebRequestEnhance) {
        EBResponse ebResponse = null;
        String bizType = EBContext.getContext().getBizName();
        boolean flag = false;
        for (Map.Entry<String, Map<String, Class>> entry : customizeMethodCache.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(bizType)) continue;
            flag = true;
            ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"customize", (String)"customize", (Object[])new Object[]{this.getRequest(entry.getValue().get("requestClass"), data, ebRequestEnhance)});
            break;
        }
        if (!flag) {
            throw new EBBaseException(MultiLang.getUnKnowBizTip(bizType));
        }
        return ebResponse;
    }
}

