/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxnx.dc.services.payment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnx.dc.services.Parser;
import kd.ebg.aqap.banks.jxnx.dc.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.jxnx.dc.util.FactoryUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        return FactoryUtil.setFactory(factory, "B2EBatchTrsResQry");
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EBatchTrsResQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"HistoryERPJnlNo", (String)paymentInfo.getBankBatchSeqId());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader(root);
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse((List)paymentInfos);
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        List maps = list.getChildren("Map");
        if (null == maps || maps.size() == 0) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56de\u7684<Map>\u8282\u70b9\u4e3a\u7a7a.\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001.", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        paymentInfos = this.preBatchSameItemCheck(bankPayRequest);
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String payerAcNo = map.getChildTextTrim("PayerAcNo");
            String payeeAcNo = map.getChildTextTrim("PayeeAcNo");
            String payeeAcName = map.getChildTextTrim("PayeeAcName");
            String amount = map.getChildTextTrim("Amount");
            PaymentInfo paymentInfo = PaymentImpl.selectPaymentInfo(bankPayRequest.getPaymentInfoAsArray(), payerAcNo, payeeAcNo, payeeAcName, amount);
            if (null == paymentInfo) continue;
            this.handlePayStatus(paymentInfo, returnCode, returnMsg);
        }
        this.processingBankItemDataHandler(maps);
        PayStatusMatchUtil.backBatchSameItemHandler((List)bankPayRequest.getPaymentInfos(), (boolean)false, (boolean)false);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String returnCode = element.getChildTextTrim("ReturnCode");
                    String returnMsg = element.getChildTextTrim("ReturnMsg");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, returnCode, returnMsg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String returnCode, String returnMsg) {
        if ("000000".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)returnCode, (String)returnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)returnMsg);
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String incomeNo = element.getChildText("PayeeAcNo");
        String incomeName = element.getChildText("PayeeAcName");
        String amount = element.getChildText("Amount");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBatchTrsResQry";
    }

    public String getBizDesc() {
        return null;
    }
}

