/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.CashPoolHelper;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"CMMACQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        Element row = JDomUtils.addChild((Element)list, (String)"row");
        JDomUtils.addChild((Element)row, (String)"accountNo", (String)accNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        ParserUtils.checkRspCode((BankAcnt)acnt, (String)ResManager.loadKDString((String)"\u5b9e\u4f53\u73b0\u91d1\u6c60\u4f59\u989d\u67e5\u8be2\u3002", (String)"CashPoolBalanceImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (BankResponse)rsp, (String)"AAAAAAA");
        Element list = JDomUtils.getChildElement((Element)root, (String)"list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String accountNo = JDomUtils.getChildText((Element)row, (String)"accountNo");
            String accountName = JDomUtils.getChildText((Element)row, (String)"accountName");
            String currencyID = JDomUtils.getChildText((Element)row, (String)"currencyID");
            String openBankName = JDomUtils.getChildText((Element)row, (String)"openBankName");
            String ACTP = JDomUtils.getChildText((Element)row, (String)"ACTP");
            String ZJFG = JDomUtils.getChildText((Element)row, (String)"ZJFG");
            String TPXH = JDomUtils.getChildText((Element)row, (String)"TPXH");
            String ZJBL = JDomUtils.getChildText((Element)row, (String)"ZJBL");
            String ACBL = JDomUtils.getChildText((Element)row, (String)"ACBL");
            String FZAM = JDomUtils.getChildText((Element)row, (String)"FZAM");
            String FYAM = JDomUtils.getChildText((Element)row, (String)"FYAM");
            String ZTKD = JDomUtils.getChildText((Element)row, (String)"ZTKD");
            String KYBL = JDomUtils.getChildText((Element)row, (String)"KYBL");
            String TZED = JDomUtils.getChildText((Element)row, (String)"TZED");
            String TZKD = JDomUtils.getChildText((Element)row, (String)"TZKD");
            String GXAM = JDomUtils.getChildText((Element)row, (String)"GXAM");
            String XBED = JDomUtils.getChildText((Element)row, (String)"XBED");
            String KGED = JDomUtils.getChildText((Element)row, (String)"KGED");
            String MPID = JDomUtils.getChildText((Element)row, (String)"MPID");
            String BKAM = JDomUtils.getChildText((Element)row, (String)"BKAM");
            String HXAC = JDomUtils.getChildText((Element)row, (String)"HXAC");
            String LDPH = JDomUtils.getChildText((Element)row, (String)"LDPH");
            BalanceInfo balance = new BalanceInfo();
            balanceInfos.add(balance);
            this.setBankAcnt(balance, request.getBankAcntList(), accountNo);
            this.setBankCurrency(balance, request.getBankCurrency(), currencyID);
            this.setCurrentBalance(balance, ACBL);
            this.setAvailableBalance(balance, ZJBL);
            balance.setBalanceDateTime(LocalDateTime.now());
            this.setFreezeBalance(balance, FZAM);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        return CashPoolHelper.isCashPoolAcnt(request.getHeader().getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CMMACQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u73b0\u91d1\u6c60\u4f59\u989d", (String)"CashPoolBalanceImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }
}

