/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.FixedHelper;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(FixedBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLFNDQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"qryFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"openChanl", (String)"0");
        JDomUtils.addChild((Element)root, (String)"qryType", (String)"0");
        JDomUtils.addChild((Element)root, (String)"startDate", (String)"");
        JDomUtils.addChild((Element)root, (String)"endDate", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestStr = JDomUtils.root2String((Element)root, (String)encoding);
        log.info("\u4e2d\u4fe1\u94f6\u884c\u5b9a\u671f\u6237\u4f59\u989d\u67e5\u8be2(DLFNDQRY\u63a5\u53e3)-\u8d26\u53f7\uff1a{}-\u8bf7\u6c42\u62a5\u6587\uff1a{}", new Object[]{accNo, requestStr});
        return requestStr;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        log.info("\u4e2d\u4fe1\u94f6\u884c\u5b9a\u671f\u6237\u4f59\u989d\u67e5\u8be2-\u8d26\u53f7\uff1a{}-\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{accNo, responseStr});
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element list = JDomUtils.getChildElement((Element)root, (String)"list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        String currencyID = "";
        BigDecimal currentBalance = BigDecimal.ZERO;
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String accountNo = JDomUtils.getChildText((Element)row, (String)"accountNo");
            if (!accNo.equalsIgnoreCase(accountNo) || !StringUtils.isEmpty((String)(currencyID = JDomUtils.getChildText((Element)row, (String)"cryType"))) && !currencyID.equalsIgnoreCase(request.getBankCurrency())) continue;
            String balance = JDomUtils.getChildText((Element)row, (String)"balance");
            BigDecimal bigDecimal = new BigDecimal(balance);
            currentBalance = currentBalance.add(bigDecimal);
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setCurrentBalance(currentBalance);
        balance.setBalanceDateTime(LocalDateTime.now());
        balance.setBankAcnt(acnt);
        balance.setBankCurrency(request.getBankCurrency());
        balanceInfos.add(balance);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        return FixedHelper.isFixedAcnt(request.getHeader().getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "DLFNDQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d", (String)"FixedBalanceImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }
}

