/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.CashPoolHelper;
import kd.ebg.aqap.banks.citic.dc.services.FixedHelper;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMdd");
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLHBLQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().format(fmt));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getEndDate().format(fmt));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        String accountNo = root.getChildTextTrim("accountNo");
        String accountName = root.getChildTextTrim("accountNm");
        String openBankName = root.getChildTextTrim("mngNode");
        String currencyID = root.getChildTextTrim("cryType");
        String status = root.getChildTextTrim("status");
        String statusText = root.getChildTextTrim("statusText");
        if (!"AAAAAAA".equals(status)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)status, (String)statusText));
        }
        Element list = root.getChild("list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < rows.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element element = (Element)rows.get(i);
            String currentBalance = element.getChildTextTrim("balance");
            String date = element.getChildTextTrim("date");
            this.setCurrentBalance(balanceInfo, currentBalance);
            this.setBankCurrency(balanceInfo, request.getHeader().getBankCurrency(), currencyID);
            this.setBalanceDateTime(balanceInfo, this.parseDateTime(date));
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), accountNo);
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public boolean match(BankBalanceRequest request) {
        return !CashPoolHelper.isCashPoolAcnt(request.getHeader().getAcnt().getAccNo()) && !FixedHelper.isFixedAcnt(request.getHeader().getAcnt().getAccNo());
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLHBLQRY";
    }

    public int queryDays() {
        return 30;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    private LocalDateTime parseDateTime(String dateStr) {
        LocalDateTime localDateTime;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = formatter.parse(dateStr);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            localDateTime = LocalDateTime.ofInstant(instant, zone);
        }
        catch (Exception ex) {
            return null;
        }
        return localDateTime;
    }
}

