/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.allocation;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CMMANSWP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u624b\u52a8\u5f52\u96c6\u5bf9\u5e94\u8bf7\u6c42\u4ee3\u7801:CMMANSWP, \u624b\u52a8\u4e0b\u62e8\u5bf9\u5e94\u8bf7\u6c42\u4ee3\u7801:CMDWNSWP", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? "CMMANSWP" : "CMDWNSWP"));
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)root, (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? "conAccountNo" : "coreAccountNo"), (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? paymentInfo.getIncomeAccNo() : paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? paymentInfo.getAccNo() : paymentInfo.getIncomeAccNo()));
        JDomUtils.addChild((Element)root, (String)"tranAmount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        LocalDateTime localDateTime = LocalDateTime.now();
        JDomUtils.addChild((Element)root, (String)"preDate", (String)localDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"preTime", (String)localDateTime.format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"abstract", (String)paymentInfo.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2String((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

