/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.individual;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.PaymentUtils;
import kd.ebg.aqap.banks.citic.dc.services.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLOTHSUB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e(\u5176\u4ed6\u4ee3\u4ed8\u5bfc\u5165)", (String)"IndividualPaymentImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !BankBusinessConfig.isAllTransfer() && paymentInfo.getIndividual() != false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLOTHSUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)("" + paymentInfos.size()));
        Element totalAmountElement = JDomUtils.addChild((Element)root, (String)"totalAmount", (String)"");
        JDomUtils.addChild((Element)root, (String)"payAccountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"preTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"recAccountNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"tranAmount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"abstract", (String)BizNoUtil.cont((String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId(), (String)"\u2605", (String)PaymentUtils.getFixedExplanation(((PaymentInfo)paymentInfos.get(i)).getExplanation(), 92)));
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)row, (String)"memo", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
        }
        totalAmountElement.setText(totalAmt.toString());
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parseBatchPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

