/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.salary.newimpl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.StatusCodeHelper;
import kd.ebg.aqap.banks.citic.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryImpl.class);
    private static Map<String, String> sucessMap = new HashMap<String, String>(16);
    private static Map<String, String> submitedMap = new HashMap<String, String>(16);
    private static Map<String, String> unknownMap = new HashMap<String, String>(16);

    public int getBatchSize() {
        return 9999;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLUPRDET");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        JDomUtils.addChild((Element)root, (String)"stt", (String)"");
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        if ("AAAAAAA".equals(status)) {
            Element list = root.getChild("list");
            List rowList = list.getChildren("row");
            if (rowList == null || rowList.size() == 0) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)" \u8fd4\u56de<row>\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"SalaryQueryImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
                return new EBBankPayResponse(paymentInfos);
            }
            this.bankDetailSeqMatch(paymentInfos, rowList);
        } else if (StatusCodeHelper.isDoingCode(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryImpl_30", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)status, (String)statusText);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)status, (String)statusText);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void bankDetailSeqMatch(List<PaymentInfo> paymentInfos, List rowList) {
        HashMap<String, PaymentInfo> tempMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo info : paymentInfos) {
            if (!StringUtils.isNotEmpty((String)info.getBankDetailSeqID())) continue;
            tempMap.put(info.getBankDetailSeqID(), info);
        }
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            String statusRow = row.getChildTextTrim("status");
            String statusTextRow = row.getChildTextTrim("statusText");
            String field1 = row.getChildTextTrim("field1");
            PaymentInfo info = null;
            if (StringUtils.isNotEmpty((String)field1)) {
                info = (PaymentInfo)tempMap.get(field1);
            }
            if (info == null) continue;
            this.handlePayStatus(info, statusRow, statusTextRow);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLUPRDET";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u79c1\u4ed8\u6b3e\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3DLUPRDET", (String)"SalaryQueryImpl_32", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    @Override
    public String getBankDataKey(Element row) {
        String recAccountName = row.getChildTextTrim("recAccountName");
        String recAccountNo = row.getChildTextTrim("recAccountNo");
        String tranAmount = row.getChildTextTrim("tranAmount");
        return recAccountNo + recAccountName + new BigDecimal(tranAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, Element row) {
        String statusRow = row.getChildTextTrim("status");
        String statusTextRow = row.getChildTextTrim("statusText");
        this.handlePayStatus(tempInfo, statusRow, statusTextRow);
    }

    public void handlePayStatus(PaymentInfo info, String statusRow, String statusTextRow) {
        if (!StringUtils.isEmpty((String)sucessMap.get(statusRow))) {
            this.logger.info("\u8f6c\u6362\u540e\u4ea4\u6613\u72b6\u6001\uff1a\u4ea4\u6613\u6210\u529f");
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryImpl_29", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if (!StringUtils.isEmpty((String)submitedMap.get(statusRow))) {
            this.logger.info("\u8f6c\u6362\u540e\u4ea4\u6613\u72b6\u6001\uff1a\u94f6\u884c\u5904\u7406\u4e2d");
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryImpl_30", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if (StatusCodeHelper.isUnkownCode(statusRow) || !StringUtils.isEmpty((String)unknownMap.get(statusRow))) {
            this.logger.info("\u8f6c\u6362\u540e\u4ea4\u6613\u72b6\u6001\uff1a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if (StringUtils.isEmpty((String)statusRow)) {
            this.logger.info("\u8f6c\u6362\u540e\u4ea4\u6613\u72b6\u6001\uff1a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else {
            this.logger.info("\u8f6c\u6362\u540e\u4ea4\u6613\u72b6\u6001\uff1a\u4ea4\u6613\u5931\u8d25");
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryImpl_31", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        }
    }

    static {
        sucessMap.put("AAAAAAA", ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u6210\u529f", (String)"SalaryQueryImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("AAAAAAB", ResManager.loadKDString((String)"\u7ecf\u529e\u6210\u529f\u5f85\u5ba1\u6838", (String)"SalaryQueryImpl_3", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("AAAAAAC", ResManager.loadKDString((String)"\u9884\u7ea6\u652f\u4ed8\u6210\u529f", (String)"SalaryQueryImpl_4", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("AAAAAAD", ResManager.loadKDString((String)"\u73b0\u91d1\u7ba1\u7406\u4ee3\u7406\u6536\u6b3e\u4fe1\u606f\u67e5\u8be2\u4ea4\u6613\u4e13\u7528\uff0c\u8868\u793a\u6263\u6b3e\u65b9\u5ba1\u6838\u901a\u8fc7\uff0c\u6263\u6b3e\u6210\u529f\u3002", (String)"SalaryQueryImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("AAAAAAE", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u884c\u5904\u7406\uff0c\u9700\u7a0d\u540e\u4f7f\u7528\u201c\u4ea4\u6613\u72b6\u6001\u67e5\u8be2\u201d\u4ea4\u6613\uff08\u89c13.6.6\uff09\u8fdb\u884c\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_6", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("AAAAAAF", ResManager.loadKDString((String)"\u6279\u6b21\u5bfc\u5165\u63d0\u4ea4\u6210\u529f\u3002", (String)"SalaryQueryImpl_7", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CCCCCCC", ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"SalaryQueryImpl_8", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP07823", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u4e8e\u7ebf\u7a0b\u5904\u7406\u4e2d\u72b6\u6001\u3002", (String)"SalaryQueryImpl_9", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP07818", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u4e8e\u5ba1\u6838\u4e2d\u72b6\u6001\u3002", (String)"SalaryQueryImpl_10", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP07819", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u5ba1\u6838\u5b8c\u6210,\u7b49\u5f85\u53d1\u9001\u4e3b\u673a\u72b6\u6001", (String)"SalaryQueryImpl_11", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CMUP043", ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_12", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CMUP040", ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SalaryQueryImpl_13", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01135", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u4e8e\u4e3b\u673a\u5904\u7406\u4e2d\u72b6\u6001\u3002", (String)"SalaryQueryImpl_14", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01141", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u4e8e\u7ebf\u7a0b\u5904\u7406\u4e2d\u72b6\u6001\u3002", (String)"SalaryQueryImpl_9", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP11001", ResManager.loadKDString((String)"\u6279\u91cf\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_15", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP11010", ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_12", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CMUP061", ResManager.loadKDString((String)"\u4ea4\u6613\u5f85\u5ba1\u6838\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_16", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CMUP063", ResManager.loadKDString((String)"\u4ea4\u6613\u7b49\u5f85\u7ee7\u7eed\u5ba1\u6838\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_17", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01129", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u73b0\u5904\u4e8e\u5f85\u5ba1\u6838\u72b6\u6001\u3002", (String)"SalaryQueryImpl_18", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01131", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u73b0\u5904\u4e8e\u5ba1\u6838\u4e2d\u72b6\u6001\u3002", (String)"SalaryQueryImpl_19", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01132", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u73b0\u5904\u5ba1\u6838\u5b8c\u6210,\u7b49\u5f85\u53d1\u9001\u4e3b\u673a\u72b6\u6001", (String)"SalaryQueryImpl_20", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        submitedMap.put("CP01133", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u73b0\u5904\u4e8e\u9884\u7ea6\u6210\u529f,\u7b49\u5f85\u53d1\u9001\u4e3b\u673a", (String)"SalaryQueryImpl_21", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("CP07824", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u73b0\u5904\u4e8e\u64a4\u9500\u72b6\u6001\u672a\u77e5\t\u3002\t", (String)"SalaryQueryImpl_22", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("CP01140", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u5df2\u7ecf\u63d0\u4ea4\u5e76\u4e14\u72b6\u6001\u672a\u77e5\u3002", (String)"SalaryQueryImpl_23", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("BBBBBBB", ResManager.loadKDString((String)"\u6279\u6b21\u5904\u7406\u90e8\u5206\u6210\u529f\u3002", (String)"SalaryQueryImpl_24", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("CP07821", ResManager.loadKDString((String)"\u8be5\u7b14\u5355\u5b50\u4ea4\u6613\u5904\u7406\u5931\u8d25(\u90e8\u5206\u5931\u8d25\u60c5\u51b5)\u3002", (String)"SalaryQueryImpl_25", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("unknown", ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("KHD0003", ResManager.loadKDString((String)"\u67e5\u8be2\u72b6\u6001\u672a\u77e5", (String)"SalaryQueryImpl_26", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("KHD0022", ResManager.loadKDString((String)"\u539f\u4ea4\u6613\u72b6\u6001\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_27", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        unknownMap.put("KHD0023", ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406\uff0c\u539f\u4ea4\u6613\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9\u6d41\u6c34\u540e\u67e5\u8be2\u3002", (String)"SalaryQueryImpl_28", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
    }
}

