/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.bug;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IBuyFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BuyFinacingImpl
extends AbstractFinancingImpl
implements IBuyFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BuyFinacingImpl.class);

    public String pack(BankFinancingRequest bankFinancingRequest) {
        List infos = bankFinancingRequest.getInfos();
        BankAcnt acnt = bankFinancingRequest.getAcnt();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFLC01", Sequence.genSequence());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)info.getCshDraFlag());
        JDomUtils.addChild((Element)corp, (String)"StartDate");
        JDomUtils.addChild((Element)corp, (String)"EndDate");
        JDomUtils.addChild((Element)corp, (String)"DbBankName", (String)acnt.getBankName());
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)acnt.getAccName());
        Element pds = JDomUtils.addChild((Element)root, (String)"Pds");
        JDomUtils.addChild((Element)pds, (String)"ProNo", (String)info.getProductCode());
        JDomUtils.addChild((Element)pds, (String)"ProductName", (String)info.getProductName());
        JDomUtils.addChild((Element)pds, (String)"RskLvl");
        JDomUtils.addChild((Element)pds, (String)"ComDat");
        JDomUtils.addChild((Element)pds, (String)"StpDat");
        JDomUtils.addChild((Element)pds, (String)"ComTim");
        JDomUtils.addChild((Element)pds, (String)"StpTim");
        JDomUtils.addChild((Element)pds, (String)"UntPrice");
        JDomUtils.addChild((Element)pds, (String)"PurchasePrice");
        JDomUtils.addChild((Element)pds, (String)"ProfitType");
        JDomUtils.addChild((Element)pds, (String)"ExpectDes");
        JDomUtils.addChild((Element)pds, (String)"Subfee");
        JDomUtils.addChild((Element)pds, (String)"PStartDate");
        JDomUtils.addChild((Element)pds, (String)"PEndDate");
        JDomUtils.addChild((Element)pds, (String)"PStartTime");
        JDomUtils.addChild((Element)pds, (String)"PEndTime");
        JDomUtils.addChild((Element)pds, (String)"PrdBuyStatus");
        JDomUtils.addChild((Element)pds, (String)"PrdDueDes");
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount());
        Element fs = JDomUtils.addChild((Element)root, (String)"Fs");
        JDomUtils.addChild((Element)fs, (String)"MktDate");
        JDomUtils.addChild((Element)fs, (String)"VluUnit");
        JDomUtils.addChild((Element)fs, (String)"TotUnit");
        JDomUtils.addChild((Element)fs, (String)"UnitBonus");
        JDomUtils.addChild((Element)fs, (String)"MyraidPft");
        JDomUtils.addChild((Element)fs, (String)"SevDaysPft");
        JDomUtils.addChild((Element)fs, (String)"RgePft");
        JDomUtils.addChild((Element)fs, (String)"TotRgePft");
        JDomUtils.addChild((Element)fs, (String)"YearPft");
        JDomUtils.addChild((Element)fs, (String)"TotYearPft");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName");
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u8d2d\u4e70\u8bf7\u6c42\u62a5\u6587");
        return result;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest request, String rspStr) {
        this.logger.info("\u7406\u8d22\u8d2d\u4e70\u8fd4\u56de\u62a5\u6587" + rspStr);
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        Element pds = root.getChild("Pds");
        String subContractNo = pds.getChildText("SubContractNo");
        String tracNo = pds.getChildText("TracNo");
        Element corp = root.getChild("Corp");
        String contractNo = corp.getChildText("ContractNo");
        List infos = request.getInfos();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        info.setReserved1(contractNo);
        info.setReserved2(subContractNo);
        info.setReserved3(((FinancingInfo)request.getInfos().get(0)).getProductCode());
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u59d4\u6258\u8d2d\u4e70\u5931\u8d25", (String)"BuyFinacingImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseMessage(), (String)rsp.getResponseMessage());
        } else {
            FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BuyFinacingImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseMessage(), (String)"");
        }
        result.setInfos(infos);
        return result;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CFLC01";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return true;
    }
}

