/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch;

import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABCErrCodeDataBase;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileParser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ShBatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(ShBatchQueryPayImpl.class);

    public void closeOutputStreamQuietly(OutputStream outputStream) {
    }

    public int getBatchSize() {
        return 2000;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "C602";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\uff1a\u6279\u91cf\u8bb0\u8d26\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d\u4ea4\u6613\uff08SH05\uff09\u3002", (String)"ShBatchQueryPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = ABC_DC_Packer.createABCRoot("C602");
        Element version = JDomUtils.addChild((Element)root, (String)"Version");
        JDomUtils.addChild((Element)version, (String)"CcVersion", (String)"1");
        JDomUtils.addChild((Element)root, (String)"SHAppCode", (String)"SH05");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"OrgReqDate", (String)paymentInfo.getSubmitSuccessTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)cme, (String)"OrgReqSeqNo", (String)paymentInfo.getBankBatchSeqId());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        String bizSeqId = request.getHeader().getBizSeqID();
        if (!"0000".equals(rspCode)) {
            if ("BT05".equals(rspCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u62a5\u8868\u6587\u4ef6\u4f20\u8f93\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u4ea4\u6613\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u53d1\u67e5\u8be2\u4ea4\u6613\uff1b\u5982\u679c\u957f\u65f6\u95f4\u67e5\u8be2\u90fd\u65e0\u6b63\u786e\u8fd4\u56de\uff0c\u5219\u9700\u4e0e\u94f6\u884c\u6280\u672f\u4eba\u5458\u8054\u7cfb\u8fdb\u884c\u7cfb\u7edf\u6392\u67e5\u3002", (String)"ShBatchQueryPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rspCode, (String)rsp.getResponseMessage());
            } else if ("1015".equals(rspCode)) {
                LocalDateTime submintDate = paymentInfos[0].getSubmitSuccessTime();
                LocalDateTime plusDays = submintDate.plusDays(25L);
                LocalDateTime now = LocalDateTime.now();
                boolean flag = now.isBefore(plusDays);
                if (flag) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspCode, (String)rsp.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"ShBatchQueryPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rspCode, (String)rsp.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"ShBatchQueryPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rspCode, (String)rsp.getResponseMessage());
            }
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element cme = root.getChild("Cme");
        String checkStatus = cme.getChildTextTrim("CheckStatus");
        String oLBPRespCode = cme.getChildTextTrim("OLBPRespCode");
        String orgReqSeqNo = cme.getChildTextTrim("OrgReqSeqNo");
        if ("4".equals(checkStatus)) {
            Element cmp = root.getChild("Cmp");
            String fileName = cmp.getChildTextTrim("BatchFileName");
            try {
                this.log.info("\u4e0b\u8f7d\u4ee3\u53d1\u7ed3\u679c\u6587\u4ef6\u5f00\u59cb" + fileName + ":...");
                String fileContent = new ABC_DCFileUtil().downloadFile(fileName, bizSeqId);
                this.log.info("\u6210\u529f\u4e0b\u8f7d\u4ee3\u53d1\u7ed3\u679c\u6587\u4ef6,\u6587\u4ef6\u5185\u5bb9:");
                this.log.info(fileContent);
                ABC_DCFileParser.parseQueryWagePaymentStateMessageInFile(fileContent, orgReqSeqNo, paymentInfos);
            }
            catch (Throwable t) {
                throw EBExceiptionUtil.serviceException((Throwable)t);
            }
        } else if ("1".equals(checkStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)oLBPRespCode, (String)ABCErrCodeDataBase.getValue(oLBPRespCode));
        } else if ("2".equals(checkStatus) || "3".equals(checkStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u8bb0\u5e10\u4ea4\u6613\u5df2\u7ecf\u6210\u529f\u53d1\u8d77\uff0c\u4f46\u8fd8\u4e0d\u80fd\u786e\u5b9a\u4ea4\u6613\u662f\u5426\u5df2\u7ecf\u5b8c\u6210\uff0c\u9700\u8981\u7a0d\u540e\u8fdb\u4e00\u6b65\u67e5\u8be2\u3002", (String)"ShBatchQueryPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)oLBPRespCode, (String)ABCErrCodeDataBase.getValue(oLBPRespCode));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)oLBPRespCode, (String)ABCErrCodeDataBase.getValue(oLBPRespCode));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

