/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opb.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.opb.service.balance.BalanceImpl;
import kd.ebg.aqap.banks.gdb.opb.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.gdb.opb.service.detail.DetailImpl;
import kd.ebg.aqap.banks.gdb.opb.service.payment.single.QuerySinglePayImpl;
import kd.ebg.aqap.banks.gdb.opb.service.payment.single.SinglePayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class GdbOpbMetaDataImpl
extends OPAMetaDataTemplate {
    public static final String BANK_VERSION_ID = "GDB_OPB";
    public static final String CST_NO = "cst_no";
    public static final String APP_ID = "app_id";
    public static final String OP_NO = "op_no";
    public static final String OP_PD = "op_pd";
    public static final String privateKey = "private_key";
    public static final String publicKey = "public_key";

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c", (String)"GdbOpbMetaDataImpl_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        this.setBankVersionID(BANK_VERSION_ID);
        this.setBankShortName("GDB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c\u4e91\u76f4\u8054\u7248", (String)"GdbOpbMetaDataImpl_1", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5e7f\u4e1c\u53d1\u5c55\u94f6\u884c", (String)"GdbOpbMetaDataImpl_2", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u670d\u52a1\u7f51\u5173\u5730\u5740", "GdbOpbMetaDataImpl_3", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bf7\u6c42\u94f6\u884c\u7684IP\u5730\u5740/\u57df\u540d\uff0c\u6d4b\u8bd5\u73af\u5883\u7531\u94f6\u884c\u63d0\u4f9b\uff0c\u751f\u4ea7\u73af\u5883\u56fa\u5b9a\u4e3a\uff1aebank.cgbchina.com.cn\u3002", "GdbOpbMetaDataImpl_4", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7aef\u53e3\u53f7", "GdbOpbMetaDataImpl_5", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bf7\u6c42\u94f6\u884c\u7684\u7aef\u53e3\u53f7\uff0c\u6d4b\u8bd5\u73af\u5883\u7531\u94f6\u884c\u63d0\u4f9b\uff0c\u751f\u4ea7\u73af\u5883\u56fa\u5b9a\u4e3a\uff1a443\u3002", "GdbOpbMetaDataImpl_6", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false).set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)).set2MaxValueNum(65535), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeUri", (String)"URI", (String)"", (String)"/deib/E1DEIB/E101", (boolean)true, (boolean)false, (boolean)false).set2MlDesc(new MultiLangEnumBridge("\u8bf7\u6c42\u94f6\u884c\u7684URI\uff0c\u56fa\u5b9a\u4e3a\uff1a/deib/E1DEIB/E101\u3002", "GdbOpbMetaDataImpl_7", "ebg-aqap-banks-gdb-opb")), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "GdbOpbMetaDataImpl_8", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "GdbOpbMetaDataImpl_8", "ebg-aqap-banks-gdb-opb"), (String)"HTTPS", (boolean)true, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"timeout", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d85\u65f6\u8bbe\u7f6e(\u5355\u4f4d\uff1a\u5206\u949f)", "GdbOpbMetaDataImpl_9", "ebg-aqap-banks-gdb-opb"), (String)"3").set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "GdbOpbMetaDataImpl_10", "ebg-aqap-banks-gdb-opb"), (String)"UTF-8").set2ReadOnly()});
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CST_NO, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u53f7", "GdbOpbMetaDataImpl_11", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u53f7\uff0c\u94f6\u884c\u63d0\u4f9b", "GdbOpbMetaDataImpl_12", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)APP_ID, (String)"APPID", (String)"", (String)"", (boolean)false, (boolean)false).set2MlDesc(new MultiLangEnumBridge("appid\uff0c\u94f6\u884c\u63d0\u4f9b\u6216\u4ece\u6570\u5b57\u8bc1\u4e66\u5185\u67e5\u8be2\u3002", "GdbOpbMetaDataImpl_13", "ebg-aqap-banks-gdb-opb")), BankLoginConfigUtil.getMlBankLoginConfig((String)OP_NO, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5458", "GdbOpbMetaDataImpl_14", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b", "GdbOpbMetaDataImpl_18", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)OP_PD, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5458\u5bc6\u7801", "GdbOpbMetaDataImpl_15", "ebg-aqap-banks-gdb-opb"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b", "GdbOpbMetaDataImpl_18", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false).set2password()});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    public List<BankLoginConfig> getBankPGPConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)privateKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u79c1\u94a5\u6587\u4ef6", "GdbOpbMetaDataImpl_16", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getMlBankLoginConfig((String)publicKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u516c\u94a5\u6587\u4ef6", "GdbOpbMetaDataImpl_17", "ebg-aqap-banks-gdb-opb"), (String)"", (boolean)false, (boolean)false, (String)"upload")});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, HisBalanceImpl.class, DetailImpl.class, SinglePayImpl.class, QuerySinglePayImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("trxDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("uniqueCode", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

