/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.service.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opb.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.opb.service.payment.single.QuerySinglePayImpl;
import kd.ebg.aqap.banks.gdb.opb.util.Packer;
import kd.ebg.aqap.banks.gdb.opb.util.Parser;
import kd.ebg.aqap.banks.gdb.opb.util.SendUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SinglePayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse doBiz(BankPayRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QuerySinglePayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Header", (Object)Packer.createHeader(this.getBizCode()));
        JSONObject body = new JSONObject();
        jsonObject.put("Body", (Object)body);
        body.put("tradeTypeNo", (Object)"AC0ZA001");
        body.put("entBizDt", (Object)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        body.put("entBizId", (Object)paymentInfo.getBankBatchSeqID());
        body.put("payerAcctNo", (Object)paymentInfo.getAccNo());
        body.put("payerAcctName", (Object)paymentInfo.getAccName());
        body.put("payeeAcctNo", (Object)paymentInfo.getIncomeAccNo());
        body.put("payeeAcctName", (Object)paymentInfo.getIncomeAccName());
        body.put("payeeBkFlag", (Object)(paymentInfo.is2SameBank() ? "B" : "T"));
        body.put("amount", (Object)paymentInfo.getAmount().toString());
        if (!paymentInfo.is2SameBank()) {
            body.put("payeeBkName", (Object)paymentInfo.getIncomeBankName());
        }
        if (StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SinglePayImpl_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        }
        String remark = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            remark = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)"");
        }
        body.put("remark", (Object)remark);
        body.put("postscript", (Object)PaymentUtil.substringChinese((boolean)false, (String)paymentInfo.getExplanation(), (int)64, (String)RequestContextUtils.getCharset()));
        if (paymentInfo.is2Individual()) {
            String useCode = UseKeyWordService.getUseByKey((String)paymentInfo.getCustomID(), (String)paymentInfo.getUseCN(), (String)this.getBizCode(), (String)paymentInfo.getUseCode(), (String)"GDB_OPB");
            body.put("addWord", (Object)useCode);
        }
        return jsonObject.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        BankResponse response = Parser.parseHeader(jsonObject.getJSONObject("Header"));
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        JSONObject body = jsonObject.getJSONObject("Body");
        String bizSts = body.getString("bizSts");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)sysRetCode, (String)sysRetInfo);
        } else {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)sysRetCode, (String)sysRetInfo);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "0021";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26", (String)"SinglePayImpl_1", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType());
    }
}

