/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.nbb.opa.services.payment.single.QrySinglePayImpl;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SinglePaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SinglePaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySinglePayImpl.class;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String ret;
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        try {
            NBBUtil.initSdk(request.getHeader().getCustomerID());
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            String corpCode = BankBusinessConfig.getCode(request.getAcnt().getAccNo());
            if (StringUtils.isEmpty((String)corpCode)) {
                corpCode = RequestContextUtils.getBankParameterValue((String)"corpCode");
            }
            JSONObject reqStr = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("custId", (Object)custId);
            data.put("serialNo", (Object)paymentInfo.getBankBatchSeqId());
            data.put("corpCode", (Object)corpCode);
            data.put("rcvAcc", (Object)paymentInfo.getIncomeAccNo());
            data.put("payAcc", (Object)paymentInfo.getAccNo());
            data.put("rcvBankName", (Object)paymentInfo.getIncomeBankName());
            data.put("rcvName", (Object)paymentInfo.getIncomeAccName());
            data.put("purpose", (Object)paymentInfo.getExplanation());
            data.put("amt", (Object)paymentInfo.getAmount());
            reqStr.put("Data", (Object)data);
            ret = NBBUtil.send("singleTransfer", "singleTransfer", reqStr.toJSONString(), this.getBizDesc());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        JSONObject retJson = JSONObject.parseObject((String)ret);
        JSONObject retData = retJson.getJSONObject("Data");
        String code = retData.getString("retCode");
        String msg = retData.getString("retMsg");
        if ("0000".equalsIgnoreCase(code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)msg, (String)"", (String)"");
        } else if (NBBUtil.retCodeMap.containsKey(code)) {
            if ("9999".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)NBBUtil.retCodeMap.get(code), (String)"", (String)msg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)NBBUtil.retCodeMap.get(code), (String)"", (String)msg);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de\u672a\u77e5\u7684\u94f6\u884cRetCode\u7801\uff0cRetCode\u4e3a%1$s,\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u4e3a%2$s", (String)"SinglePaymentImpl_2", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]), code, msg));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "singleTransfer/singleTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8", (String)"SinglePaymentImpl_1", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getTotalCount() == 1;
    }
}

