/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balancereconciliation;

import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBalanceStatement
extends AbstractImpl {
    public BalanceReconciliationDetail getStmtNo(String accNo, String startDate, String endDate) {
        Element root = BOCOM_DC_Packer.packRoot("999008");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"accNo", (String)accNo);
        LocalDate start = LocalDate.parse(startDate + "01", DateTimeFormatter.ofPattern("yyyyMMdd"));
        LocalDate end = YearMonth.parse(endDate, DateTimeFormatter.ofPattern("yyyyMM")).atEndOfMonth();
        JDomUtils.addChild((Element)body, (String)"startDt", (String)start.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDt", (String)end.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"status", (String)"1");
        String response = this.sendAndRcv4Query(JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset()));
        return this.parse(response);
    }

    private BalanceReconciliationDetail parse(String response) {
        Element ap = JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element body = ap.getChild("body");
            Element resultList = body.getChild("resultList");
            Element record = resultList.getChild("Record");
            String stmtNo = JDomUtils.getChildText((Element)record, (String)"StmtNo");
            String issueDate = JDomUtils.getChildText((Element)record, (String)"IssueDate");
            BalanceReconciliationDetail balanceReconciliationDetail = new BalanceReconciliationDetail();
            balanceReconciliationDetail.setStatementNo(stmtNo);
            balanceReconciliationDetail.setMonth(issueDate);
            return balanceReconciliationDetail;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u5355\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"QueryBalanceStatement_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
    }

    /*
     * Exception decompiling
     */
    private String sendAndRcv4Query(String sendMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

