/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.balance;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.ebg.aqap.banks.sjb.cms.services.detail.RespFileUtils;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceParser.class);

    public static EBBankBalanceResponse parseHisBalance(BankBalanceRequest req, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(8);
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            logger.error("###\u672c\u6b21\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002");
            return new EBBankBalanceResponse(balances);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equalsIgnoreCase(file_flag)) {
            logger.info("##\u672c\u6b21\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            content = new RespFileUtils().getRspFileData(file_name);
        } else {
            logger.info("###\u672c\u6b21\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        for (String[] r : TCommon.parseMFS(content, recordNum, fieldNum)) {
            balances.add(HisBalanceParser.parseBal(req, r));
        }
        return new EBBankBalanceResponse(balances);
    }

    public static BalanceInfo parseBal(BankBalanceRequest req, String[] r) {
        String balance = r[0];
        String date = r[2];
        BalanceInfo balanceInfo = new BalanceInfo();
        BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)req.getAcnt());
        BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)req.getBankCurrency());
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (String)(date + "000000"), (DateTimeFormatter)DateTimeFormatter.ofPattern("yy.MM.ddHHmmss"));
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)balance);
        return balanceInfo;
    }
}

