/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.payment.salary;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sjb.cms.services.payment.salary.ProxyDownload;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static void parseQueryPay(List<PaymentInfo> infos, String rspStr) throws EBServiceException {
        String content;
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            EBGBusinessUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570=%s\u3002", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), record_num));
            return;
        }
        String file_flag = head.getChildTextTrim("file_flag");
        if ("1".equals(file_flag)) {
            logger.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                ProxyDownload proxyDownload = new ProxyDownload();
                content = proxyDownload.doBiz(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            logger.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] rs = QueryPayParser.parseRecord(content, recordNum, fieldNum);
        for (int i = 1; i < rs.length; ++i) {
            logger.info(Arrays.asList(rs[i]).toString());
            String ACNO = rs[i][1];
            String ACNAME = rs[i][3];
            String AMT = rs[i][5];
            String SUMMARY = rs[i][6];
            String STAT = rs[i][9];
            String ERR_MSG = rs[i][10];
            String BATCH_NO = rs[i][11];
            PaymentInfo payInfo = QueryPayParser.findPaymentInfo(infos, BATCH_NO, ACNO, ACNAME, AMT);
            if (null == payInfo) continue;
            if ("1".equals(STAT) || "5".equals(STAT) || "6".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]));
                continue;
            }
            if ("F".equals(STAT) || "3".equals(STAT) || "4".equals(STAT) || "8".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("0".equals(STAT) || "2".equals(STAT) || "7".equals(STAT) || "9".equals(STAT) || "A".equals(STAT) || "R".equals(STAT) || "S".equals(STAT) || "Z".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)STAT, (String)ERR_MSG);
        }
    }

    private static PaymentInfo findPaymentInfo(List<PaymentInfo> infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {
        String packageId = infos.get(0).getPackageId();
        for (PaymentInfo pay : infos) {
            if (!packageId.equals(BATCH_NO) || !pay.getIncomeAccNo().equals(ACNO) || !pay.getIncomeAccName().equals(ACNAME) || !pay.getAmount().toPlainString().equals(AMT)) continue;
            return pay;
        }
        return null;
    }

    private static String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        logger.info("###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

