/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EHisActBalQry");
    }

    public String pack(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element root = Packer.buildHead("B2EHisActBalQry", null);
        Element Map2 = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)Map2, (String)"BeginDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element list = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List");
        List records = list.getChildren("Map");
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < records.size(); ++i) {
            Element record = (Element)records.get(i);
            BalanceInfo hisBalance = new BalanceInfo();
            infos.add(hisBalance);
            String accNo = record.getChildText("AcctNo");
            this.setBankAcnt(hisBalance, bankBalanceRequest.getBankAcntList(), accNo);
            String currency = record.getChildText("Currency");
            this.setBankCurrency(hisBalance, bankBalanceRequest.getBankCurrency(), currency);
            String balanceDateTime = record.getChildText("TransDate") + " " + record.getChildText("TransTime");
            this.setBalanceDateTime(hisBalance, balanceDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HHmmss"));
            String Avaibal = record.getChildText("Avaibal");
            this.setCurrentBalance(hisBalance, Avaibal);
            String Balance = record.getChildText("Balance");
            this.setAvailableBalance(hisBalance, Balance);
            String Avalcredit = record.getChildText("Avalcredit");
            this.setLastDayAvlBalance(hisBalance, Avalcredit);
        }
        ebBankBalanceResponse.setBalances(infos);
        return ebBankBalanceResponse;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EHisActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }
}

