/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.payment.salary.QrySalPaymentImpl;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalPaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EAgentSalaryEnt");
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("B2EAgentSalaryEnt", paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAccountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"PayerCurrencyCode", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"PayerCurrencyCRFlag", (String)"C");
        JDomUtils.addChild((Element)body, (String)"TotalAmount");
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"OpenBranch", (String)paymentInfo.getBankName());
        JDomUtils.addChild((Element)body, (String)"FundUsage", (String)paymentInfo.getUseCN());
        JDomUtils.addChild((Element)body, (String)"PostScript", (String)paymentInfo.getExplanation());
        BigDecimal amount = new BigDecimal("0.00");
        Element Map2 = body.getChild("List").getChild("Map");
        int j = paymentInfos.size();
        for (int i = 0; i < j; ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            if (i > 0) {
                Map2 = JDomUtils.addChild((Element)body.getChild("List"), (String)"Map");
            }
            String sqrNbr = String.format("%012d", i + 1);
            JDomUtils.addChild((Element)Map2, (String)"SqrNbr", (String)sqrNbr);
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)Map2, (String)"PayeeDeptName", (String)info.getIncomeBankName());
            if (info.is2SameBank()) {
                JDomUtils.addChild((Element)Map2, (String)"PayeeBankId", (String)"");
                JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)"");
            } else {
                JDomUtils.addChild((Element)Map2, (String)"PayeeBankId", (String)info.getIncomeCnaps());
                JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)info.getIncomeBankName());
            }
            JDomUtils.addChild((Element)Map2, (String)"Amount", (String)info.getAmount().toPlainString());
            JDomUtils.addChild((Element)Map2, (String)"OthbankFlag", (String)(info.is2SameBank() ? "0" : "1"));
            JDomUtils.addChild((Element)Map2, (String)"TransferLevel", (String)"1");
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcType", (String)"8");
            JDomUtils.addChild((Element)Map2, (String)"PaymentPurpose", (String)info.getExplanation());
            JDomUtils.addChild((Element)Map2, (String)"FundUsage", (String)info.getUseCN());
            amount = amount.add(info.getAmount());
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"SqrNbr", (String)sqrNbr);
        }
        JDomUtils.getChildElement((Element)body, (String)"TotalAmount").addContent(amount.toPlainString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element body = root.getChild("Body");
            String status = JDomUtils.getChildText((Element)body, (String)"ReturnCode");
            String returnMsg = JDomUtils.getChildText((Element)body, (String)"ReturnMsg");
            String batchNo = JDomUtils.getChildText((Element)body, (String)"BatchNo");
            String transDate = JDomUtils.getChildText((Element)body, (String)"TransDate");
            for (PaymentInfo info : paymentInfos) {
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)"batchNo", (String)batchNo);
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)"transDate", (String)transDate);
            }
            if ("000000".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"SalPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalPaymentImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalPaymentImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EAgentSalaryEnt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u4ee3\u53d1\u5de5\u8d44", (String)"SalPaymentImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

