/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.detail;

import java.util.Calendar;
import java.util.Date;
import kd.ebg.aqap.banks.zyb.dc.utils.DateUtils;
import kd.ebg.aqap.banks.zyb.dc.utils.GLBPacker;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailPacker.class);
    private static final String TRANCODE = "05B2EActTrsQry";

    public String packHisDetail(BankDetailRequest request, String pageTag) throws EBServiceException {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(TRANCODE));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request, pageTag, "100"));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    public String packTodayDetail(BankDetailRequest request, String pageTag) throws EBServiceException {
        return this.packHisDetail(request, pageTag);
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) throws EBServiceException {
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"Current_Num", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"Total_Num", (String)page);
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)DateTimeUtils.format((Date)DateUtils.LocalDateToDate(request.getStartDate()), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)DateTimeUtils.format((Date)DateUtils.LocalDateToDate(request.getEndDate()), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"Currency", (String)request.getBankCurrency());
        this.log.info(DateTimeUtils.format((Date)DateUtils.LocalDateToDate(request.getStartDate()), (String)"yyyyMMdd"));
        this.log.info(DateTimeUtils.format((Date)DateUtils.LocalDateToDate(request.getEndDate()), (String)"yyyyMMdd"));
        return body;
    }

    private boolean isOverDateSpan(BankDetailRequest request) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.LocalDateToDate(request.getStartDate()));
        c.add(2, 3);
        long startTime = c.getTimeInMillis();
        c.setTime(DateUtils.LocalDateToDate(request.getEndDate()));
        long endTime = c.getTimeInMillis();
        return endTime - startTime > 0L;
    }
}

