/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.anz.dc;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem ANZ_DC_BICCODE = PropertyConfigItem.builder().key("ANZ_DC_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "BankBusinessConfig_0", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWIFT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_18", "ebg-aqap-banks-anz-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u6709\uff1aACH\u3001BPAY\u3001CBFT\u3001NPP\u3001RTGS\u63a5\u53e3\u3002", "BankBusinessConfig_19", "ebg-aqap-banks-anz-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem ANZ_DC_BANKCITY = PropertyConfigItem.builder().key("ANZ_DC_BANKCITY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-anz-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem ANZ_DC_PAY_COMPANY = PropertyConfigItem.builder().key("ANZ_DC_PAY_COMPANY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-anz-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem ANZ_DC_PAY_COMPANY_STREET = PropertyConfigItem.builder().key("ANZ_DC_PAY_COMPANY_STREET").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-anz-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem ANZ_DC_USER_ID = PropertyConfigItem.builder().key("ANZ_DC_USER_ID").mlName(new MultiLangEnumBridge("\u7528\u6237ID", "BankBusinessConfig_4", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7528\u6237ID\uff08\u6fb3\u6d32\u5730\u533aACH\u4ed8\u6b3e\u4f7f\u7528\uff09", "BankBusinessConfig_5", "ebg-aqap-banks-anz-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem ANZ_DC_BATCH_NUMBER = PropertyConfigItem.builder().key("ANZ_DC_BATCH_NUMBER").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6587\u4ef6\u5305\u542b\u7684\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\u3002", "BankBusinessConfig_6", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u6587\u4ef6\u4e2d\u53ef\u5305\u542b\u7684\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\u3002", "BankBusinessConfig_13", "ebg-aqap-banks-anz-dc"), new MultiLangEnumBridge("\u914d\u7f6e\u8be5\u53c2\u6570\u540e\uff0c\u94f6\u4f01\u4e91\u5c06\u6309\u7167\u914d\u7f6e\u503c\u8bbe\u7f6e\u6279\u6b21\u5927\u5c0f\u3002", "BankBusinessConfig_14", "ebg-aqap-banks-anz-dc"), new MultiLangEnumBridge("\u4e0d\u8bbe\u7f6e\u5219\u9ed8\u8ba4100", "BankBusinessConfig_15", "ebg-aqap-banks-anz-dc")})).set2Integer().set2MinValueNum(Integer.valueOf(1)).defaultValues((List)Lists.newArrayList((Object[])new String[]{"100"})).build();
    public static final PropertyConfigItem ANZ_DC_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("ANZ_DC_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_10", "ebg-aqap-banks-anz-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002", "BankBusinessConfig_16", "ebg-aqap-banks-anz-dc"), new MultiLangEnumBridge("\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_17", "ebg-aqap-banks-anz-dc")})).set2Integer().set2MinValueNum(Integer.valueOf(0)).defaultValues((List)Lists.newArrayList((Object[])new String[]{"0"})).build();

    public static int getBatchNumber() {
        String config = ANZ_DC_BATCH_NUMBER.getCurrentValue();
        if (null != config && config.length() > 0) {
            try {
                int batchNumber = Integer.parseInt(config);
                return batchNumber;
            }
            catch (NumberFormatException e) {
                return 100;
            }
        }
        return 100;
    }

    public static int getPayStateTimeout() {
        String config = ANZ_DC_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != config && config.length() > 0) {
            try {
                if (Integer.parseInt(config) > 0) {
                    timeout = Integer.parseInt(config);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static String getUserId(String accNo) {
        return ANZ_DC_USER_ID.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompany(String accNo) {
        return ANZ_DC_PAY_COMPANY.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompanyStreet(String accNo) {
        return ANZ_DC_PAY_COMPANY_STREET.getCurrentValueWithObjectID(accNo);
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime time = submitSuccessTime.plus(payStateTimeout * 60 * 60, ChronoUnit.SECONDS);
        return time.isBefore(LocalDateTime.now());
    }

    public static String getBicCode(String accNo) {
        return ANZ_DC_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankCity(String accNo) {
        return ANZ_DC_BANKCITY.getCurrentValueWithObjectID(accNo);
    }

    public boolean isForeignBank() {
        return true;
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List configItemList = this.getBankAddtionalPropertyConfigItems(false, false, true, false);
        configItemList.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{ANZ_DC_BICCODE, ANZ_DC_BANKCITY, ANZ_DC_PAY_COMPANY, ANZ_DC_PAY_COMPANY_STREET, ANZ_DC_USER_ID, ANZ_DC_BATCH_NUMBER, ANZ_DC_PAY_STATE_TIMEOUT}));
        return configItemList;
    }
}

