/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.anz.dc.service.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.anz.dc.service.ANZ_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayParser {
    public static void parsePay(List<PaymentInfo> paymentInfos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = ANZ_DC_Parser.parseHeader(root);
        if ("BIZ_FAIL".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"PayParser_0", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String sequence = JDomUtils.getChildTextTrim((Element)list, (String)"sequence");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)sequence);
            if (null == info) continue;
            if ("BCC_PAY_SUBMT_SUCCESS".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_1", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_FAIL".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_2", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayParser_3", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
    }
}

